/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VerificationType {
    BUSINESS_VERIFICATION("BUSINESS_VERIFICATION"),
    REGISTRANT_VERIFICATION("REGISTRANT_VERIFICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VerificationType> VALUE_MAP;
    private final String value;

    private VerificationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VerificationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VerificationType> knownValues() {
        EnumSet<VerificationType> knownValues = EnumSet.allOf(VerificationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VerificationType.class, VerificationType::toString);
    }
}

