/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PrimarySolutionType {
    SOFTWARE_PRODUCTS("SOFTWARE_PRODUCTS"),
    CONSULTING_SERVICES("CONSULTING_SERVICES"),
    PROFESSIONAL_SERVICES("PROFESSIONAL_SERVICES"),
    MANAGED_SERVICES("MANAGED_SERVICES"),
    HARDWARE_PRODUCTS("HARDWARE_PRODUCTS"),
    COMMUNICATION_SERVICES("COMMUNICATION_SERVICES"),
    VALUE_ADDED_RESALE_AWS_SERVICES("VALUE_ADDED_RESALE_AWS_SERVICES"),
    TRAINING_SERVICES("TRAINING_SERVICES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PrimarySolutionType> VALUE_MAP;
    private final String value;

    private PrimarySolutionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PrimarySolutionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PrimarySolutionType> knownValues() {
        EnumSet<PrimarySolutionType> knownValues = EnumSet.allOf(PrimarySolutionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PrimarySolutionType.class, PrimarySolutionType::toString);
    }
}

