/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionSummary;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionSummaryListCopier;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectionsResponse
extends PartnerCentralAccountResponse
implements ToCopyableBuilder<Builder, ListConnectionsResponse> {
    private static final SdkField<List<ConnectionSummary>> CONNECTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionSummaries").getter(ListConnectionsResponse.getter(ListConnectionsResponse::connectionSummaries)).setter(ListConnectionsResponse.setter(Builder::connectionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConnectionsResponse.getter(ListConnectionsResponse::nextToken)).setter(ListConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConnectionsResponse.memberNameToFieldInitializer();
    private final List<ConnectionSummary> connectionSummaries;
    private final String nextToken;

    private ListConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.connectionSummaries = builder.connectionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConnectionSummaries() {
        return this.connectionSummaries != null && !(this.connectionSummaries instanceof SdkAutoConstructList);
    }

    public final List<ConnectionSummary> connectionSummaries() {
        return this.connectionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionSummaries() ? this.connectionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionsResponse)) {
            return false;
        }
        ListConnectionsResponse other = (ListConnectionsResponse)((Object)obj);
        return this.hasConnectionSummaries() == other.hasConnectionSummaries() && Objects.equals(this.connectionSummaries(), other.connectionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectionsResponse").add("ConnectionSummaries", this.hasConnectionSummaries() ? this.connectionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionSummaries": {
                return Optional.ofNullable(clazz.cast(this.connectionSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionSummaries", CONNECTION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionsResponse, T> g) {
        return obj -> g.apply((ListConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountResponse.BuilderImpl
    implements Builder {
        private List<ConnectionSummary> connectionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionsResponse model) {
            super(model);
            this.connectionSummaries(model.connectionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ConnectionSummary.Builder> getConnectionSummaries() {
            List<ConnectionSummary.Builder> result = ConnectionSummaryListCopier.copyToBuilder(this.connectionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionSummaries(Collection<ConnectionSummary.BuilderImpl> connectionSummaries) {
            this.connectionSummaries = ConnectionSummaryListCopier.copyFromBuilder(connectionSummaries);
        }

        @Override
        public final Builder connectionSummaries(Collection<ConnectionSummary> connectionSummaries) {
            this.connectionSummaries = ConnectionSummaryListCopier.copy(connectionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionSummaries(ConnectionSummary ... connectionSummaries) {
            this.connectionSummaries(Arrays.asList(connectionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionSummaries(Consumer<ConnectionSummary.Builder> ... connectionSummaries) {
            this.connectionSummaries(Stream.of(connectionSummaries).map(c -> (ConnectionSummary)((ConnectionSummary.Builder)ConnectionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectionsResponse build() {
            return new ListConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectionsResponse> {
        public Builder connectionSummaries(Collection<ConnectionSummary> var1);

        public Builder connectionSummaries(ConnectionSummary ... var1);

        public Builder connectionSummaries(Consumer<ConnectionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

