/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionType;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionTypeDetail;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionTypeDetailMapCopier;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelConnectionResponse
extends PartnerCentralAccountResponse
implements ToCopyableBuilder<Builder, CancelConnectionResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(CancelConnectionResponse.getter(CancelConnectionResponse::catalog)).setter(CancelConnectionResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CancelConnectionResponse.getter(CancelConnectionResponse::id)).setter(CancelConnectionResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CancelConnectionResponse.getter(CancelConnectionResponse::arn)).setter(CancelConnectionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> OTHER_PARTICIPANT_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtherParticipantAccountId").getter(CancelConnectionResponse.getter(CancelConnectionResponse::otherParticipantAccountId)).setter(CancelConnectionResponse.setter(Builder::otherParticipantAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherParticipantAccountId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(CancelConnectionResponse.getter(CancelConnectionResponse::updatedAt)).setter(CancelConnectionResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, ConnectionTypeDetail>> CONNECTION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionTypes").getter(CancelConnectionResponse.getter(CancelConnectionResponse::connectionTypesAsStrings)).setter(CancelConnectionResponse.setter(Builder::connectionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTypes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionTypeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ID_FIELD, ARN_FIELD, OTHER_PARTICIPANT_ACCOUNT_ID_FIELD, UPDATED_AT_FIELD, CONNECTION_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelConnectionResponse.memberNameToFieldInitializer();
    private final String catalog;
    private final String id;
    private final String arn;
    private final String otherParticipantAccountId;
    private final Instant updatedAt;
    private final Map<String, ConnectionTypeDetail> connectionTypes;

    private CancelConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.id = builder.id;
        this.arn = builder.arn;
        this.otherParticipantAccountId = builder.otherParticipantAccountId;
        this.updatedAt = builder.updatedAt;
        this.connectionTypes = builder.connectionTypes;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String otherParticipantAccountId() {
        return this.otherParticipantAccountId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Map<ConnectionType, ConnectionTypeDetail> connectionTypes() {
        return ConnectionTypeDetailMapCopier.copyStringToEnum(this.connectionTypes);
    }

    public final boolean hasConnectionTypes() {
        return this.connectionTypes != null && !(this.connectionTypes instanceof SdkAutoConstructMap);
    }

    public final Map<String, ConnectionTypeDetail> connectionTypesAsStrings() {
        return this.connectionTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherParticipantAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionTypes() ? this.connectionTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelConnectionResponse)) {
            return false;
        }
        CancelConnectionResponse other = (CancelConnectionResponse)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.otherParticipantAccountId(), other.otherParticipantAccountId()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasConnectionTypes() == other.hasConnectionTypes() && Objects.equals(this.connectionTypesAsStrings(), other.connectionTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CancelConnectionResponse").add("Catalog", (Object)this.catalog()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("OtherParticipantAccountId", (Object)this.otherParticipantAccountId()).add("UpdatedAt", (Object)this.updatedAt()).add("ConnectionTypes", this.hasConnectionTypes() ? this.connectionTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "OtherParticipantAccountId": {
                return Optional.ofNullable(clazz.cast(this.otherParticipantAccountId()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "ConnectionTypes": {
                return Optional.ofNullable(clazz.cast(this.connectionTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("OtherParticipantAccountId", OTHER_PARTICIPANT_ACCOUNT_ID_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("ConnectionTypes", CONNECTION_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelConnectionResponse, T> g) {
        return obj -> g.apply((CancelConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountResponse.BuilderImpl
    implements Builder {
        private String catalog;
        private String id;
        private String arn;
        private String otherParticipantAccountId;
        private Instant updatedAt;
        private Map<String, ConnectionTypeDetail> connectionTypes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelConnectionResponse model) {
            super(model);
            this.catalog(model.catalog);
            this.id(model.id);
            this.arn(model.arn);
            this.otherParticipantAccountId(model.otherParticipantAccountId);
            this.updatedAt(model.updatedAt);
            this.connectionTypesWithStrings(model.connectionTypes);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOtherParticipantAccountId() {
            return this.otherParticipantAccountId;
        }

        public final void setOtherParticipantAccountId(String otherParticipantAccountId) {
            this.otherParticipantAccountId = otherParticipantAccountId;
        }

        @Override
        public final Builder otherParticipantAccountId(String otherParticipantAccountId) {
            this.otherParticipantAccountId = otherParticipantAccountId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, ConnectionTypeDetail.Builder> getConnectionTypes() {
            Map<String, ConnectionTypeDetail.Builder> result = ConnectionTypeDetailMapCopier.copyToBuilder(this.connectionTypes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConnectionTypes(Map<String, ConnectionTypeDetail.BuilderImpl> connectionTypes) {
            this.connectionTypes = ConnectionTypeDetailMapCopier.copyFromBuilder(connectionTypes);
        }

        @Override
        public final Builder connectionTypesWithStrings(Map<String, ConnectionTypeDetail> connectionTypes) {
            this.connectionTypes = ConnectionTypeDetailMapCopier.copy(connectionTypes);
            return this;
        }

        @Override
        public final Builder connectionTypes(Map<ConnectionType, ConnectionTypeDetail> connectionTypes) {
            this.connectionTypes = ConnectionTypeDetailMapCopier.copyEnumToString(connectionTypes);
            return this;
        }

        @Override
        public CancelConnectionResponse build() {
            return new CancelConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelConnectionResponse> {
        public Builder catalog(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder otherParticipantAccountId(String var1);

        public Builder updatedAt(Instant var1);

        public Builder connectionTypesWithStrings(Map<String, ConnectionTypeDetail> var1);

        public Builder connectionTypes(Map<ConnectionType, ConnectionTypeDetail> var1);
    }
}

