/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.IndustrySegment;
import software.amazon.awssdk.services.partnercentralaccount.model.IndustrySegmentListCopier;
import software.amazon.awssdk.services.partnercentralaccount.model.LocalizedContent;
import software.amazon.awssdk.services.partnercentralaccount.model.LocalizedContentListCopier;
import software.amazon.awssdk.services.partnercentralaccount.model.PrimarySolutionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartnerProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartnerProfile> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(PartnerProfile.getter(PartnerProfile::displayName)).setter(PartnerProfile.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PartnerProfile.getter(PartnerProfile::description)).setter(PartnerProfile.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebsiteUrl").getter(PartnerProfile.getter(PartnerProfile::websiteUrl)).setter(PartnerProfile.setter(Builder::websiteUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()}).build();
    private static final SdkField<String> LOGO_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogoUrl").getter(PartnerProfile.getter(PartnerProfile::logoUrl)).setter(PartnerProfile.setter(Builder::logoUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoUrl").build()}).build();
    private static final SdkField<String> PRIMARY_SOLUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimarySolutionType").getter(PartnerProfile.getter(PartnerProfile::primarySolutionTypeAsString)).setter(PartnerProfile.setter(Builder::primarySolutionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimarySolutionType").build()}).build();
    private static final SdkField<List<String>> INDUSTRY_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IndustrySegments").getter(PartnerProfile.getter(PartnerProfile::industrySegmentsAsStrings)).setter(PartnerProfile.setter(Builder::industrySegmentsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndustrySegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRANSLATION_SOURCE_LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranslationSourceLocale").getter(PartnerProfile.getter(PartnerProfile::translationSourceLocale)).setter(PartnerProfile.setter(Builder::translationSourceLocale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranslationSourceLocale").build()}).build();
    private static final SdkField<List<LocalizedContent>> LOCALIZED_CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalizedContents").getter(PartnerProfile.getter(PartnerProfile::localizedContents)).setter(PartnerProfile.setter(Builder::localizedContents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalizedContents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(PartnerProfile.getter(PartnerProfile::profileId)).setter(PartnerProfile.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, WEBSITE_URL_FIELD, LOGO_URL_FIELD, PRIMARY_SOLUTION_TYPE_FIELD, INDUSTRY_SEGMENTS_FIELD, TRANSLATION_SOURCE_LOCALE_FIELD, LOCALIZED_CONTENTS_FIELD, PROFILE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PartnerProfile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String displayName;
    private final String description;
    private final String websiteUrl;
    private final String logoUrl;
    private final String primarySolutionType;
    private final List<String> industrySegments;
    private final String translationSourceLocale;
    private final List<LocalizedContent> localizedContents;
    private final String profileId;

    private PartnerProfile(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.websiteUrl = builder.websiteUrl;
        this.logoUrl = builder.logoUrl;
        this.primarySolutionType = builder.primarySolutionType;
        this.industrySegments = builder.industrySegments;
        this.translationSourceLocale = builder.translationSourceLocale;
        this.localizedContents = builder.localizedContents;
        this.profileId = builder.profileId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final String websiteUrl() {
        return this.websiteUrl;
    }

    public final String logoUrl() {
        return this.logoUrl;
    }

    public final PrimarySolutionType primarySolutionType() {
        return PrimarySolutionType.fromValue(this.primarySolutionType);
    }

    public final String primarySolutionTypeAsString() {
        return this.primarySolutionType;
    }

    public final List<IndustrySegment> industrySegments() {
        return IndustrySegmentListCopier.copyStringToEnum(this.industrySegments);
    }

    public final boolean hasIndustrySegments() {
        return this.industrySegments != null && !(this.industrySegments instanceof SdkAutoConstructList);
    }

    public final List<String> industrySegmentsAsStrings() {
        return this.industrySegments;
    }

    public final String translationSourceLocale() {
        return this.translationSourceLocale;
    }

    public final boolean hasLocalizedContents() {
        return this.localizedContents != null && !(this.localizedContents instanceof SdkAutoConstructList);
    }

    public final List<LocalizedContent> localizedContents() {
        return this.localizedContents;
    }

    public final String profileId() {
        return this.profileId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.primarySolutionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndustrySegments() ? this.industrySegmentsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.translationSourceLocale());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalizedContents() ? this.localizedContents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnerProfile)) {
            return false;
        }
        PartnerProfile other = (PartnerProfile)obj;
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.websiteUrl(), other.websiteUrl()) && Objects.equals(this.logoUrl(), other.logoUrl()) && Objects.equals(this.primarySolutionTypeAsString(), other.primarySolutionTypeAsString()) && this.hasIndustrySegments() == other.hasIndustrySegments() && Objects.equals(this.industrySegmentsAsStrings(), other.industrySegmentsAsStrings()) && Objects.equals(this.translationSourceLocale(), other.translationSourceLocale()) && this.hasLocalizedContents() == other.hasLocalizedContents() && Objects.equals(this.localizedContents(), other.localizedContents()) && Objects.equals(this.profileId(), other.profileId());
    }

    public final String toString() {
        return ToString.builder((String)"PartnerProfile").add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("WebsiteUrl", (Object)this.websiteUrl()).add("LogoUrl", (Object)this.logoUrl()).add("PrimarySolutionType", (Object)this.primarySolutionTypeAsString()).add("IndustrySegments", this.hasIndustrySegments() ? this.industrySegmentsAsStrings() : null).add("TranslationSourceLocale", (Object)this.translationSourceLocale()).add("LocalizedContents", this.hasLocalizedContents() ? this.localizedContents() : null).add("ProfileId", (Object)this.profileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "WebsiteUrl": {
                return Optional.ofNullable(clazz.cast(this.websiteUrl()));
            }
            case "LogoUrl": {
                return Optional.ofNullable(clazz.cast(this.logoUrl()));
            }
            case "PrimarySolutionType": {
                return Optional.ofNullable(clazz.cast(this.primarySolutionTypeAsString()));
            }
            case "IndustrySegments": {
                return Optional.ofNullable(clazz.cast(this.industrySegmentsAsStrings()));
            }
            case "TranslationSourceLocale": {
                return Optional.ofNullable(clazz.cast(this.translationSourceLocale()));
            }
            case "LocalizedContents": {
                return Optional.ofNullable(clazz.cast(this.localizedContents()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("WebsiteUrl", WEBSITE_URL_FIELD);
        map.put("LogoUrl", LOGO_URL_FIELD);
        map.put("PrimarySolutionType", PRIMARY_SOLUTION_TYPE_FIELD);
        map.put("IndustrySegments", INDUSTRY_SEGMENTS_FIELD);
        map.put("TranslationSourceLocale", TRANSLATION_SOURCE_LOCALE_FIELD);
        map.put("LocalizedContents", LOCALIZED_CONTENTS_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartnerProfile, T> g) {
        return obj -> g.apply((PartnerProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String displayName;
        private String description;
        private String websiteUrl;
        private String logoUrl;
        private String primarySolutionType;
        private List<String> industrySegments = DefaultSdkAutoConstructList.getInstance();
        private String translationSourceLocale;
        private List<LocalizedContent> localizedContents = DefaultSdkAutoConstructList.getInstance();
        private String profileId;

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerProfile model) {
            this.displayName(model.displayName);
            this.description(model.description);
            this.websiteUrl(model.websiteUrl);
            this.logoUrl(model.logoUrl);
            this.primarySolutionType(model.primarySolutionType);
            this.industrySegmentsWithStrings(model.industrySegments);
            this.translationSourceLocale(model.translationSourceLocale);
            this.localizedContents(model.localizedContents);
            this.profileId(model.profileId);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getWebsiteUrl() {
            return this.websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public final String getLogoUrl() {
            return this.logoUrl;
        }

        public final void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        @Override
        public final Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public final String getPrimarySolutionType() {
            return this.primarySolutionType;
        }

        public final void setPrimarySolutionType(String primarySolutionType) {
            this.primarySolutionType = primarySolutionType;
        }

        @Override
        public final Builder primarySolutionType(String primarySolutionType) {
            this.primarySolutionType = primarySolutionType;
            return this;
        }

        @Override
        public final Builder primarySolutionType(PrimarySolutionType primarySolutionType) {
            this.primarySolutionType(primarySolutionType == null ? null : primarySolutionType.toString());
            return this;
        }

        public final Collection<String> getIndustrySegments() {
            if (this.industrySegments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.industrySegments;
        }

        public final void setIndustrySegments(Collection<String> industrySegments) {
            this.industrySegments = IndustrySegmentListCopier.copy(industrySegments);
        }

        @Override
        public final Builder industrySegmentsWithStrings(Collection<String> industrySegments) {
            this.industrySegments = IndustrySegmentListCopier.copy(industrySegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder industrySegmentsWithStrings(String ... industrySegments) {
            this.industrySegmentsWithStrings(Arrays.asList(industrySegments));
            return this;
        }

        @Override
        public final Builder industrySegments(Collection<IndustrySegment> industrySegments) {
            this.industrySegments = IndustrySegmentListCopier.copyEnumToString(industrySegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder industrySegments(IndustrySegment ... industrySegments) {
            this.industrySegments(Arrays.asList(industrySegments));
            return this;
        }

        public final String getTranslationSourceLocale() {
            return this.translationSourceLocale;
        }

        public final void setTranslationSourceLocale(String translationSourceLocale) {
            this.translationSourceLocale = translationSourceLocale;
        }

        @Override
        public final Builder translationSourceLocale(String translationSourceLocale) {
            this.translationSourceLocale = translationSourceLocale;
            return this;
        }

        public final List<LocalizedContent.Builder> getLocalizedContents() {
            List<LocalizedContent.Builder> result = LocalizedContentListCopier.copyToBuilder(this.localizedContents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalizedContents(Collection<LocalizedContent.BuilderImpl> localizedContents) {
            this.localizedContents = LocalizedContentListCopier.copyFromBuilder(localizedContents);
        }

        @Override
        public final Builder localizedContents(Collection<LocalizedContent> localizedContents) {
            this.localizedContents = LocalizedContentListCopier.copy(localizedContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localizedContents(LocalizedContent ... localizedContents) {
            this.localizedContents(Arrays.asList(localizedContents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localizedContents(Consumer<LocalizedContent.Builder> ... localizedContents) {
            this.localizedContents(Stream.of(localizedContents).map(c -> (LocalizedContent)((LocalizedContent.Builder)LocalizedContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public PartnerProfile build() {
            return new PartnerProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartnerProfile> {
        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder websiteUrl(String var1);

        public Builder logoUrl(String var1);

        public Builder primarySolutionType(String var1);

        public Builder primarySolutionType(PrimarySolutionType var1);

        public Builder industrySegmentsWithStrings(Collection<String> var1);

        public Builder industrySegmentsWithStrings(String ... var1);

        public Builder industrySegments(Collection<IndustrySegment> var1);

        public Builder industrySegments(IndustrySegment ... var1);

        public Builder translationSourceLocale(String var1);

        public Builder localizedContents(Collection<LocalizedContent> var1);

        public Builder localizedContents(LocalizedContent ... var1);

        public Builder localizedContents(Consumer<LocalizedContent.Builder> ... var1);

        public Builder profileId(String var1);
    }
}

