/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.AllianceLeadContact;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountRequest;
import software.amazon.awssdk.services.partnercentralaccount.model.PrimarySolutionType;
import software.amazon.awssdk.services.partnercentralaccount.model.Tag;
import software.amazon.awssdk.services.partnercentralaccount.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePartnerRequest
extends PartnerCentralAccountRequest
implements ToCopyableBuilder<Builder, CreatePartnerRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(CreatePartnerRequest.getter(CreatePartnerRequest::catalog)).setter(CreatePartnerRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreatePartnerRequest.getter(CreatePartnerRequest::clientToken)).setter(CreatePartnerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> LEGAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LegalName").getter(CreatePartnerRequest.getter(CreatePartnerRequest::legalName)).setter(CreatePartnerRequest.setter(Builder::legalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalName").build()}).build();
    private static final SdkField<String> PRIMARY_SOLUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimarySolutionType").getter(CreatePartnerRequest.getter(CreatePartnerRequest::primarySolutionTypeAsString)).setter(CreatePartnerRequest.setter(Builder::primarySolutionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimarySolutionType").build()}).build();
    private static final SdkField<AllianceLeadContact> ALLIANCE_LEAD_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AllianceLeadContact").getter(CreatePartnerRequest.getter(CreatePartnerRequest::allianceLeadContact)).setter(CreatePartnerRequest.setter(Builder::allianceLeadContact)).constructor(AllianceLeadContact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllianceLeadContact").build()}).build();
    private static final SdkField<String> EMAIL_VERIFICATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailVerificationCode").getter(CreatePartnerRequest.getter(CreatePartnerRequest::emailVerificationCode)).setter(CreatePartnerRequest.setter(Builder::emailVerificationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationCode").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreatePartnerRequest.getter(CreatePartnerRequest::tags)).setter(CreatePartnerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CLIENT_TOKEN_FIELD, LEGAL_NAME_FIELD, PRIMARY_SOLUTION_TYPE_FIELD, ALLIANCE_LEAD_CONTACT_FIELD, EMAIL_VERIFICATION_CODE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePartnerRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String clientToken;
    private final String legalName;
    private final String primarySolutionType;
    private final AllianceLeadContact allianceLeadContact;
    private final String emailVerificationCode;
    private final List<Tag> tags;

    private CreatePartnerRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.legalName = builder.legalName;
        this.primarySolutionType = builder.primarySolutionType;
        this.allianceLeadContact = builder.allianceLeadContact;
        this.emailVerificationCode = builder.emailVerificationCode;
        this.tags = builder.tags;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String legalName() {
        return this.legalName;
    }

    public final PrimarySolutionType primarySolutionType() {
        return PrimarySolutionType.fromValue(this.primarySolutionType);
    }

    public final String primarySolutionTypeAsString() {
        return this.primarySolutionType;
    }

    public final AllianceLeadContact allianceLeadContact() {
        return this.allianceLeadContact;
    }

    public final String emailVerificationCode() {
        return this.emailVerificationCode;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.primarySolutionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allianceLeadContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailVerificationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePartnerRequest)) {
            return false;
        }
        CreatePartnerRequest other = (CreatePartnerRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.legalName(), other.legalName()) && Objects.equals(this.primarySolutionTypeAsString(), other.primarySolutionTypeAsString()) && Objects.equals(this.allianceLeadContact(), other.allianceLeadContact()) && Objects.equals(this.emailVerificationCode(), other.emailVerificationCode()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePartnerRequest").add("Catalog", (Object)this.catalog()).add("ClientToken", (Object)this.clientToken()).add("LegalName", (Object)(this.legalName() == null ? null : "*** Sensitive Data Redacted ***")).add("PrimarySolutionType", (Object)this.primarySolutionTypeAsString()).add("AllianceLeadContact", (Object)this.allianceLeadContact()).add("EmailVerificationCode", (Object)(this.emailVerificationCode() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "LegalName": {
                return Optional.ofNullable(clazz.cast(this.legalName()));
            }
            case "PrimarySolutionType": {
                return Optional.ofNullable(clazz.cast(this.primarySolutionTypeAsString()));
            }
            case "AllianceLeadContact": {
                return Optional.ofNullable(clazz.cast(this.allianceLeadContact()));
            }
            case "EmailVerificationCode": {
                return Optional.ofNullable(clazz.cast(this.emailVerificationCode()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("LegalName", LEGAL_NAME_FIELD);
        map.put("PrimarySolutionType", PRIMARY_SOLUTION_TYPE_FIELD);
        map.put("AllianceLeadContact", ALLIANCE_LEAD_CONTACT_FIELD);
        map.put("EmailVerificationCode", EMAIL_VERIFICATION_CODE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePartnerRequest, T> g) {
        return obj -> g.apply((CreatePartnerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String clientToken;
        private String legalName;
        private String primarySolutionType;
        private AllianceLeadContact allianceLeadContact;
        private String emailVerificationCode;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePartnerRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.clientToken(model.clientToken);
            this.legalName(model.legalName);
            this.primarySolutionType(model.primarySolutionType);
            this.allianceLeadContact(model.allianceLeadContact);
            this.emailVerificationCode(model.emailVerificationCode);
            this.tags(model.tags);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLegalName() {
            return this.legalName;
        }

        public final void setLegalName(String legalName) {
            this.legalName = legalName;
        }

        @Override
        public final Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }

        public final String getPrimarySolutionType() {
            return this.primarySolutionType;
        }

        public final void setPrimarySolutionType(String primarySolutionType) {
            this.primarySolutionType = primarySolutionType;
        }

        @Override
        public final Builder primarySolutionType(String primarySolutionType) {
            this.primarySolutionType = primarySolutionType;
            return this;
        }

        @Override
        public final Builder primarySolutionType(PrimarySolutionType primarySolutionType) {
            this.primarySolutionType(primarySolutionType == null ? null : primarySolutionType.toString());
            return this;
        }

        public final AllianceLeadContact.Builder getAllianceLeadContact() {
            return this.allianceLeadContact != null ? this.allianceLeadContact.toBuilder() : null;
        }

        public final void setAllianceLeadContact(AllianceLeadContact.BuilderImpl allianceLeadContact) {
            this.allianceLeadContact = allianceLeadContact != null ? allianceLeadContact.build() : null;
        }

        @Override
        public final Builder allianceLeadContact(AllianceLeadContact allianceLeadContact) {
            this.allianceLeadContact = allianceLeadContact;
            return this;
        }

        public final String getEmailVerificationCode() {
            return this.emailVerificationCode;
        }

        public final void setEmailVerificationCode(String emailVerificationCode) {
            this.emailVerificationCode = emailVerificationCode;
        }

        @Override
        public final Builder emailVerificationCode(String emailVerificationCode) {
            this.emailVerificationCode = emailVerificationCode;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePartnerRequest build() {
            return new CreatePartnerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePartnerRequest> {
        public Builder catalog(String var1);

        public Builder clientToken(String var1);

        public Builder legalName(String var1);

        public Builder primarySolutionType(String var1);

        public Builder primarySolutionType(PrimarySolutionType var1);

        public Builder allianceLeadContact(AllianceLeadContact var1);

        default public Builder allianceLeadContact(Consumer<AllianceLeadContact.Builder> allianceLeadContact) {
            return this.allianceLeadContact((AllianceLeadContact)((AllianceLeadContact.Builder)AllianceLeadContact.builder().applyMutation(allianceLeadContact)).build());
        }

        public Builder emailVerificationCode(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

