/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceNotFoundExceptionReason {
    PARTNER_NOT_FOUND("PARTNER_NOT_FOUND"),
    PARTNER_PROFILE_NOT_FOUND("PARTNER_PROFILE_NOT_FOUND"),
    PARTNER_PROFILE_TASK_NOT_FOUND("PARTNER_PROFILE_TASK_NOT_FOUND"),
    PARTNER_DOMAIN_NOT_FOUND("PARTNER_DOMAIN_NOT_FOUND"),
    SENDER_PROFILE_NOT_FOUND("SENDER_PROFILE_NOT_FOUND"),
    RECEIVER_PROFILE_NOT_FOUND("RECEIVER_PROFILE_NOT_FOUND"),
    CONNECTION_INVITATION_NOT_FOUND("CONNECTION_INVITATION_NOT_FOUND"),
    CONNECTION_NOT_FOUND("CONNECTION_NOT_FOUND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceNotFoundExceptionReason> VALUE_MAP;
    private final String value;

    private ResourceNotFoundExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceNotFoundExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceNotFoundExceptionReason> knownValues() {
        EnumSet<ResourceNotFoundExceptionReason> knownValues = EnumSet.allOf(ResourceNotFoundExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceNotFoundExceptionReason.class, ResourceNotFoundExceptionReason::toString);
    }
}

