/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.JobResourceTags;
import software.amazon.awssdk.services.panorama.model.JobTagsListCopier;
import software.amazon.awssdk.services.panorama.model.PackageImportJobInputConfig;
import software.amazon.awssdk.services.panorama.model.PackageImportJobOutput;
import software.amazon.awssdk.services.panorama.model.PackageImportJobOutputConfig;
import software.amazon.awssdk.services.panorama.model.PackageImportJobStatus;
import software.amazon.awssdk.services.panorama.model.PackageImportJobType;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePackageImportJobResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribePackageImportJobResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::clientToken)).setter(DescribePackageImportJobResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::createdTime)).setter(DescribePackageImportJobResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<PackageImportJobInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::inputConfig)).setter(DescribePackageImportJobResponse.setter(Builder::inputConfig)).constructor(PackageImportJobInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::jobId)).setter(DescribePackageImportJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<List<JobResourceTags>> JOB_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobTags").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::jobTags)).setter(DescribePackageImportJobResponse.setter(Builder::jobTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobResourceTags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::jobTypeAsString)).setter(DescribePackageImportJobResponse.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::lastUpdatedTime)).setter(DescribePackageImportJobResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<PackageImportJobOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Output").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::output)).setter(DescribePackageImportJobResponse.setter(Builder::output)).constructor(PackageImportJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<PackageImportJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::outputConfig)).setter(DescribePackageImportJobResponse.setter(Builder::outputConfig)).constructor(PackageImportJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::statusAsString)).setter(DescribePackageImportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DescribePackageImportJobResponse.getter(DescribePackageImportJobResponse::statusMessage)).setter(DescribePackageImportJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CREATED_TIME_FIELD, INPUT_CONFIG_FIELD, JOB_ID_FIELD, JOB_TAGS_FIELD, JOB_TYPE_FIELD, LAST_UPDATED_TIME_FIELD, OUTPUT_FIELD, OUTPUT_CONFIG_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePackageImportJobResponse.memberNameToFieldInitializer();
    private final String clientToken;
    private final Instant createdTime;
    private final PackageImportJobInputConfig inputConfig;
    private final String jobId;
    private final List<JobResourceTags> jobTags;
    private final String jobType;
    private final Instant lastUpdatedTime;
    private final PackageImportJobOutput output;
    private final PackageImportJobOutputConfig outputConfig;
    private final String status;
    private final String statusMessage;

    private DescribePackageImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.createdTime = builder.createdTime;
        this.inputConfig = builder.inputConfig;
        this.jobId = builder.jobId;
        this.jobTags = builder.jobTags;
        this.jobType = builder.jobType;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.output = builder.output;
        this.outputConfig = builder.outputConfig;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final PackageImportJobInputConfig inputConfig() {
        return this.inputConfig;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final boolean hasJobTags() {
        return this.jobTags != null && !(this.jobTags instanceof SdkAutoConstructList);
    }

    public final List<JobResourceTags> jobTags() {
        return this.jobTags;
    }

    public final PackageImportJobType jobType() {
        return PackageImportJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final PackageImportJobOutput output() {
        return this.output;
    }

    public final PackageImportJobOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final PackageImportJobStatus status() {
        return PackageImportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTags() ? this.jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageImportJobResponse)) {
            return false;
        }
        DescribePackageImportJobResponse other = (DescribePackageImportJobResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.jobId(), other.jobId()) && this.hasJobTags() == other.hasJobTags() && Objects.equals(this.jobTags(), other.jobTags()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePackageImportJobResponse").add("ClientToken", (Object)this.clientToken()).add("CreatedTime", (Object)this.createdTime()).add("InputConfig", (Object)this.inputConfig()).add("JobId", (Object)this.jobId()).add("JobTags", this.hasJobTags() ? this.jobTags() : null).add("JobType", (Object)this.jobTypeAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Output", (Object)this.output()).add("OutputConfig", (Object)this.outputConfig()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobTags": {
                return Optional.ofNullable(clazz.cast(this.jobTags()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        map.put("JobId", JOB_ID_FIELD);
        map.put("JobTags", JOB_TAGS_FIELD);
        map.put("JobType", JOB_TYPE_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Output", OUTPUT_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageImportJobResponse, T> g) {
        return obj -> g.apply((DescribePackageImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String clientToken;
        private Instant createdTime;
        private PackageImportJobInputConfig inputConfig;
        private String jobId;
        private List<JobResourceTags> jobTags = DefaultSdkAutoConstructList.getInstance();
        private String jobType;
        private Instant lastUpdatedTime;
        private PackageImportJobOutput output;
        private PackageImportJobOutputConfig outputConfig;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageImportJobResponse model) {
            super(model);
            this.clientToken(model.clientToken);
            this.createdTime(model.createdTime);
            this.inputConfig(model.inputConfig);
            this.jobId(model.jobId);
            this.jobTags(model.jobTags);
            this.jobType(model.jobType);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.output(model.output);
            this.outputConfig(model.outputConfig);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final PackageImportJobInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(PackageImportJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(PackageImportJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final List<JobResourceTags.Builder> getJobTags() {
            List<JobResourceTags.Builder> result = JobTagsListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<JobResourceTags.BuilderImpl> jobTags) {
            this.jobTags = JobTagsListCopier.copyFromBuilder(jobTags);
        }

        @Override
        public final Builder jobTags(Collection<JobResourceTags> jobTags) {
            this.jobTags = JobTagsListCopier.copy(jobTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(JobResourceTags ... jobTags) {
            this.jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Consumer<JobResourceTags.Builder> ... jobTags) {
            this.jobTags(Stream.of(jobTags).map(c -> (JobResourceTags)((JobResourceTags.Builder)JobResourceTags.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(PackageImportJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final PackageImportJobOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(PackageImportJobOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(PackageImportJobOutput output) {
            this.output = output;
            return this;
        }

        public final PackageImportJobOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(PackageImportJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(PackageImportJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PackageImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public DescribePackageImportJobResponse build() {
            return new DescribePackageImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePackageImportJobResponse> {
        public Builder clientToken(String var1);

        public Builder createdTime(Instant var1);

        public Builder inputConfig(PackageImportJobInputConfig var1);

        default public Builder inputConfig(Consumer<PackageImportJobInputConfig.Builder> inputConfig) {
            return this.inputConfig((PackageImportJobInputConfig)((PackageImportJobInputConfig.Builder)PackageImportJobInputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder jobId(String var1);

        public Builder jobTags(Collection<JobResourceTags> var1);

        public Builder jobTags(JobResourceTags ... var1);

        public Builder jobTags(Consumer<JobResourceTags.Builder> ... var1);

        public Builder jobType(String var1);

        public Builder jobType(PackageImportJobType var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder output(PackageImportJobOutput var1);

        default public Builder output(Consumer<PackageImportJobOutput.Builder> output) {
            return this.output((PackageImportJobOutput)((PackageImportJobOutput.Builder)PackageImportJobOutput.builder().applyMutation(output)).build());
        }

        public Builder outputConfig(PackageImportJobOutputConfig var1);

        default public Builder outputConfig(Consumer<PackageImportJobOutputConfig.Builder> outputConfig) {
            return this.outputConfig((PackageImportJobOutputConfig)((PackageImportJobOutputConfig.Builder)PackageImportJobOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(PackageImportJobStatus var1);

        public Builder statusMessage(String var1);
    }
}

