/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.panorama.model.JobResourceTags;
import software.amazon.awssdk.services.panorama.model.JobTagsListCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.services.panorama.model.TemplateParametersMapCopier;
import software.amazon.awssdk.services.panorama.model.TemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNodeFromTemplateJobRequest
extends PanoramaRequest
implements ToCopyableBuilder<Builder, CreateNodeFromTemplateJobRequest> {
    private static final SdkField<List<JobResourceTags>> JOB_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobTags").getter(CreateNodeFromTemplateJobRequest.getter(CreateNodeFromTemplateJobRequest::jobTags)).setter(CreateNodeFromTemplateJobRequest.setter(Builder::jobTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobResourceTags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NODE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeDescription").getter(CreateNodeFromTemplateJobRequest.getter(CreateNodeFromTemplateJobRequest::nodeDescription)).setter(CreateNodeFromTemplateJobRequest.setter(Builder::nodeDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeDescription").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeName").getter(CreateNodeFromTemplateJobRequest.getter(CreateNodeFromTemplateJobRequest::nodeName)).setter(CreateNodeFromTemplateJobRequest.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeName").build()}).build();
    private static final SdkField<String> OUTPUT_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputPackageName").getter(CreateNodeFromTemplateJobRequest.getter(CreateNodeFromTemplateJobRequest::outputPackageName)).setter(CreateNodeFromTemplateJobRequest.setter(Builder::outputPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputPackageName").build()}).build();
    private static final SdkField<String> OUTPUT_PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputPackageVersion").getter(CreateNodeFromTemplateJobRequest.getter(CreateNodeFromTemplateJobRequest::outputPackageVersion)).setter(CreateNodeFromTemplateJobRequest.setter(Builder::outputPackageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputPackageVersion").build()}).build();
    private static final SdkField<Map<String, String>> TEMPLATE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TemplateParameters").getter(CreateNodeFromTemplateJobRequest.getter(CreateNodeFromTemplateJobRequest::templateParameters)).setter(CreateNodeFromTemplateJobRequest.setter(Builder::templateParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateType").getter(CreateNodeFromTemplateJobRequest.getter(CreateNodeFromTemplateJobRequest::templateTypeAsString)).setter(CreateNodeFromTemplateJobRequest.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TAGS_FIELD, NODE_DESCRIPTION_FIELD, NODE_NAME_FIELD, OUTPUT_PACKAGE_NAME_FIELD, OUTPUT_PACKAGE_VERSION_FIELD, TEMPLATE_PARAMETERS_FIELD, TEMPLATE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNodeFromTemplateJobRequest.memberNameToFieldInitializer();
    private final List<JobResourceTags> jobTags;
    private final String nodeDescription;
    private final String nodeName;
    private final String outputPackageName;
    private final String outputPackageVersion;
    private final Map<String, String> templateParameters;
    private final String templateType;

    private CreateNodeFromTemplateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobTags = builder.jobTags;
        this.nodeDescription = builder.nodeDescription;
        this.nodeName = builder.nodeName;
        this.outputPackageName = builder.outputPackageName;
        this.outputPackageVersion = builder.outputPackageVersion;
        this.templateParameters = builder.templateParameters;
        this.templateType = builder.templateType;
    }

    public final boolean hasJobTags() {
        return this.jobTags != null && !(this.jobTags instanceof SdkAutoConstructList);
    }

    public final List<JobResourceTags> jobTags() {
        return this.jobTags;
    }

    public final String nodeDescription() {
        return this.nodeDescription;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final String outputPackageName() {
        return this.outputPackageName;
    }

    public final String outputPackageVersion() {
        return this.outputPackageVersion;
    }

    public final boolean hasTemplateParameters() {
        return this.templateParameters != null && !(this.templateParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> templateParameters() {
        return this.templateParameters;
    }

    public final TemplateType templateType() {
        return TemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTags() ? this.jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputPackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateParameters() ? this.templateParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodeFromTemplateJobRequest)) {
            return false;
        }
        CreateNodeFromTemplateJobRequest other = (CreateNodeFromTemplateJobRequest)((Object)obj);
        return this.hasJobTags() == other.hasJobTags() && Objects.equals(this.jobTags(), other.jobTags()) && Objects.equals(this.nodeDescription(), other.nodeDescription()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.outputPackageName(), other.outputPackageName()) && Objects.equals(this.outputPackageVersion(), other.outputPackageVersion()) && this.hasTemplateParameters() == other.hasTemplateParameters() && Objects.equals(this.templateParameters(), other.templateParameters()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNodeFromTemplateJobRequest").add("JobTags", this.hasJobTags() ? this.jobTags() : null).add("NodeDescription", (Object)this.nodeDescription()).add("NodeName", (Object)this.nodeName()).add("OutputPackageName", (Object)this.outputPackageName()).add("OutputPackageVersion", (Object)this.outputPackageVersion()).add("TemplateParameters", (Object)(this.templateParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateType", (Object)this.templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobTags": {
                return Optional.ofNullable(clazz.cast(this.jobTags()));
            }
            case "NodeDescription": {
                return Optional.ofNullable(clazz.cast(this.nodeDescription()));
            }
            case "NodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "OutputPackageName": {
                return Optional.ofNullable(clazz.cast(this.outputPackageName()));
            }
            case "OutputPackageVersion": {
                return Optional.ofNullable(clazz.cast(this.outputPackageVersion()));
            }
            case "TemplateParameters": {
                return Optional.ofNullable(clazz.cast(this.templateParameters()));
            }
            case "TemplateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobTags", JOB_TAGS_FIELD);
        map.put("NodeDescription", NODE_DESCRIPTION_FIELD);
        map.put("NodeName", NODE_NAME_FIELD);
        map.put("OutputPackageName", OUTPUT_PACKAGE_NAME_FIELD);
        map.put("OutputPackageVersion", OUTPUT_PACKAGE_VERSION_FIELD);
        map.put("TemplateParameters", TEMPLATE_PARAMETERS_FIELD);
        map.put("TemplateType", TEMPLATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNodeFromTemplateJobRequest, T> g) {
        return obj -> g.apply((CreateNodeFromTemplateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaRequest.BuilderImpl
    implements Builder {
        private List<JobResourceTags> jobTags = DefaultSdkAutoConstructList.getInstance();
        private String nodeDescription;
        private String nodeName;
        private String outputPackageName;
        private String outputPackageVersion;
        private Map<String, String> templateParameters = DefaultSdkAutoConstructMap.getInstance();
        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodeFromTemplateJobRequest model) {
            super(model);
            this.jobTags(model.jobTags);
            this.nodeDescription(model.nodeDescription);
            this.nodeName(model.nodeName);
            this.outputPackageName(model.outputPackageName);
            this.outputPackageVersion(model.outputPackageVersion);
            this.templateParameters(model.templateParameters);
            this.templateType(model.templateType);
        }

        public final List<JobResourceTags.Builder> getJobTags() {
            List<JobResourceTags.Builder> result = JobTagsListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<JobResourceTags.BuilderImpl> jobTags) {
            this.jobTags = JobTagsListCopier.copyFromBuilder(jobTags);
        }

        @Override
        public final Builder jobTags(Collection<JobResourceTags> jobTags) {
            this.jobTags = JobTagsListCopier.copy(jobTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(JobResourceTags ... jobTags) {
            this.jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Consumer<JobResourceTags.Builder> ... jobTags) {
            this.jobTags(Stream.of(jobTags).map(c -> (JobResourceTags)((JobResourceTags.Builder)JobResourceTags.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNodeDescription() {
            return this.nodeDescription;
        }

        public final void setNodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
        }

        @Override
        public final Builder nodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getOutputPackageName() {
            return this.outputPackageName;
        }

        public final void setOutputPackageName(String outputPackageName) {
            this.outputPackageName = outputPackageName;
        }

        @Override
        public final Builder outputPackageName(String outputPackageName) {
            this.outputPackageName = outputPackageName;
            return this;
        }

        public final String getOutputPackageVersion() {
            return this.outputPackageVersion;
        }

        public final void setOutputPackageVersion(String outputPackageVersion) {
            this.outputPackageVersion = outputPackageVersion;
        }

        @Override
        public final Builder outputPackageVersion(String outputPackageVersion) {
            this.outputPackageVersion = outputPackageVersion;
            return this;
        }

        public final Map<String, String> getTemplateParameters() {
            if (this.templateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.templateParameters;
        }

        public final void setTemplateParameters(Map<String, String> templateParameters) {
            this.templateParameters = TemplateParametersMapCopier.copy(templateParameters);
        }

        @Override
        public final Builder templateParameters(Map<String, String> templateParameters) {
            this.templateParameters = TemplateParametersMapCopier.copy(templateParameters);
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodeFromTemplateJobRequest build() {
            return new CreateNodeFromTemplateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNodeFromTemplateJobRequest> {
        public Builder jobTags(Collection<JobResourceTags> var1);

        public Builder jobTags(JobResourceTags ... var1);

        public Builder jobTags(Consumer<JobResourceTags.Builder> ... var1);

        public Builder nodeDescription(String var1);

        public Builder nodeName(String var1);

        public Builder outputPackageName(String var1);

        public Builder outputPackageVersion(String var1);

        public Builder templateParameters(Map<String, String> var1);

        public Builder templateType(String var1);

        public Builder templateType(TemplateType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

