/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.Job;
import software.amazon.awssdk.services.panorama.model.JobListCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobForDevicesResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, CreateJobForDevicesResponse> {
    private static final SdkField<List<Job>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Jobs").getter(CreateJobForDevicesResponse.getter(CreateJobForDevicesResponse::jobs)).setter(CreateJobForDevicesResponse.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Job::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateJobForDevicesResponse.memberNameToFieldInitializer();
    private final List<Job> jobs;

    private CreateJobForDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
    }

    public final boolean hasJobs() {
        return this.jobs != null && !(this.jobs instanceof SdkAutoConstructList);
    }

    public final List<Job> jobs() {
        return this.jobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobs() ? this.jobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobForDevicesResponse)) {
            return false;
        }
        CreateJobForDevicesResponse other = (CreateJobForDevicesResponse)((Object)obj);
        return this.hasJobs() == other.hasJobs() && Objects.equals(this.jobs(), other.jobs());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobForDevicesResponse").add("Jobs", this.hasJobs() ? this.jobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Job>>> map = new HashMap<String, SdkField<List<Job>>>();
        map.put("Jobs", JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateJobForDevicesResponse, T> g) {
        return obj -> g.apply((CreateJobForDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private List<Job> jobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobForDevicesResponse model) {
            super(model);
            this.jobs(model.jobs);
        }

        public final List<Job.Builder> getJobs() {
            List<Job.Builder> result = JobListCopier.copyToBuilder(this.jobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobs(Collection<Job.BuilderImpl> jobs) {
            this.jobs = JobListCopier.copyFromBuilder(jobs);
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = JobListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<Job.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (Job)((Job.Builder)Job.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateJobForDevicesResponse build() {
            return new CreateJobForDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobForDevicesResponse> {
        public Builder jobs(Collection<Job> var1);

        public Builder jobs(Job ... var1);

        public Builder jobs(Consumer<Job.Builder> ... var1);
    }
}

