/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageLocation> {
    private static final SdkField<String> BINARY_PREFIX_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BinaryPrefixLocation").getter(StorageLocation.getter(StorageLocation::binaryPrefixLocation)).setter(StorageLocation.setter(Builder::binaryPrefixLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinaryPrefixLocation").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(StorageLocation.getter(StorageLocation::bucket)).setter(StorageLocation.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()}).build();
    private static final SdkField<String> GENERATED_PREFIX_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedPrefixLocation").getter(StorageLocation.getter(StorageLocation::generatedPrefixLocation)).setter(StorageLocation.setter(Builder::generatedPrefixLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedPrefixLocation").build()}).build();
    private static final SdkField<String> MANIFEST_PREFIX_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestPrefixLocation").getter(StorageLocation.getter(StorageLocation::manifestPrefixLocation)).setter(StorageLocation.setter(Builder::manifestPrefixLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestPrefixLocation").build()}).build();
    private static final SdkField<String> REPO_PREFIX_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepoPrefixLocation").getter(StorageLocation.getter(StorageLocation::repoPrefixLocation)).setter(StorageLocation.setter(Builder::repoPrefixLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepoPrefixLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BINARY_PREFIX_LOCATION_FIELD, BUCKET_FIELD, GENERATED_PREFIX_LOCATION_FIELD, MANIFEST_PREFIX_LOCATION_FIELD, REPO_PREFIX_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StorageLocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String binaryPrefixLocation;
    private final String bucket;
    private final String generatedPrefixLocation;
    private final String manifestPrefixLocation;
    private final String repoPrefixLocation;

    private StorageLocation(BuilderImpl builder) {
        this.binaryPrefixLocation = builder.binaryPrefixLocation;
        this.bucket = builder.bucket;
        this.generatedPrefixLocation = builder.generatedPrefixLocation;
        this.manifestPrefixLocation = builder.manifestPrefixLocation;
        this.repoPrefixLocation = builder.repoPrefixLocation;
    }

    public final String binaryPrefixLocation() {
        return this.binaryPrefixLocation;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String generatedPrefixLocation() {
        return this.generatedPrefixLocation;
    }

    public final String manifestPrefixLocation() {
        return this.manifestPrefixLocation;
    }

    public final String repoPrefixLocation() {
        return this.repoPrefixLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.binaryPrefixLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedPrefixLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestPrefixLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.repoPrefixLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLocation)) {
            return false;
        }
        StorageLocation other = (StorageLocation)obj;
        return Objects.equals(this.binaryPrefixLocation(), other.binaryPrefixLocation()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.generatedPrefixLocation(), other.generatedPrefixLocation()) && Objects.equals(this.manifestPrefixLocation(), other.manifestPrefixLocation()) && Objects.equals(this.repoPrefixLocation(), other.repoPrefixLocation());
    }

    public final String toString() {
        return ToString.builder((String)"StorageLocation").add("BinaryPrefixLocation", (Object)this.binaryPrefixLocation()).add("Bucket", (Object)this.bucket()).add("GeneratedPrefixLocation", (Object)this.generatedPrefixLocation()).add("ManifestPrefixLocation", (Object)this.manifestPrefixLocation()).add("RepoPrefixLocation", (Object)this.repoPrefixLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BinaryPrefixLocation": {
                return Optional.ofNullable(clazz.cast(this.binaryPrefixLocation()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "GeneratedPrefixLocation": {
                return Optional.ofNullable(clazz.cast(this.generatedPrefixLocation()));
            }
            case "ManifestPrefixLocation": {
                return Optional.ofNullable(clazz.cast(this.manifestPrefixLocation()));
            }
            case "RepoPrefixLocation": {
                return Optional.ofNullable(clazz.cast(this.repoPrefixLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BinaryPrefixLocation", BINARY_PREFIX_LOCATION_FIELD);
        map.put("Bucket", BUCKET_FIELD);
        map.put("GeneratedPrefixLocation", GENERATED_PREFIX_LOCATION_FIELD);
        map.put("ManifestPrefixLocation", MANIFEST_PREFIX_LOCATION_FIELD);
        map.put("RepoPrefixLocation", REPO_PREFIX_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageLocation, T> g) {
        return obj -> g.apply((StorageLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String binaryPrefixLocation;
        private String bucket;
        private String generatedPrefixLocation;
        private String manifestPrefixLocation;
        private String repoPrefixLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLocation model) {
            this.binaryPrefixLocation(model.binaryPrefixLocation);
            this.bucket(model.bucket);
            this.generatedPrefixLocation(model.generatedPrefixLocation);
            this.manifestPrefixLocation(model.manifestPrefixLocation);
            this.repoPrefixLocation(model.repoPrefixLocation);
        }

        public final String getBinaryPrefixLocation() {
            return this.binaryPrefixLocation;
        }

        public final void setBinaryPrefixLocation(String binaryPrefixLocation) {
            this.binaryPrefixLocation = binaryPrefixLocation;
        }

        @Override
        public final Builder binaryPrefixLocation(String binaryPrefixLocation) {
            this.binaryPrefixLocation = binaryPrefixLocation;
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getGeneratedPrefixLocation() {
            return this.generatedPrefixLocation;
        }

        public final void setGeneratedPrefixLocation(String generatedPrefixLocation) {
            this.generatedPrefixLocation = generatedPrefixLocation;
        }

        @Override
        public final Builder generatedPrefixLocation(String generatedPrefixLocation) {
            this.generatedPrefixLocation = generatedPrefixLocation;
            return this;
        }

        public final String getManifestPrefixLocation() {
            return this.manifestPrefixLocation;
        }

        public final void setManifestPrefixLocation(String manifestPrefixLocation) {
            this.manifestPrefixLocation = manifestPrefixLocation;
        }

        @Override
        public final Builder manifestPrefixLocation(String manifestPrefixLocation) {
            this.manifestPrefixLocation = manifestPrefixLocation;
            return this;
        }

        public final String getRepoPrefixLocation() {
            return this.repoPrefixLocation;
        }

        public final void setRepoPrefixLocation(String repoPrefixLocation) {
            this.repoPrefixLocation = repoPrefixLocation;
        }

        @Override
        public final Builder repoPrefixLocation(String repoPrefixLocation) {
            this.repoPrefixLocation = repoPrefixLocation;
            return this;
        }

        public StorageLocation build() {
            return new StorageLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageLocation> {
        public Builder binaryPrefixLocation(String var1);

        public Builder bucket(String var1);

        public Builder generatedPrefixLocation(String var1);

        public Builder manifestPrefixLocation(String var1);

        public Builder repoPrefixLocation(String var1);
    }
}

