/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.panorama.model.JobResourceTags;
import software.amazon.awssdk.services.panorama.model.JobTagsListCopier;
import software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.services.panorama.model.TemplateParametersMapCopier;
import software.amazon.awssdk.services.panorama.model.TemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNodeFromTemplateJobResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribeNodeFromTemplateJobResponse> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::createdTime)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::jobId)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<List<JobResourceTags>> JOB_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobTags").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::jobTags)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::jobTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobResourceTags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::lastUpdatedTime)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> NODE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeDescription").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::nodeDescription)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::nodeDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeDescription").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeName").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::nodeName)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeName").build()}).build();
    private static final SdkField<String> OUTPUT_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputPackageName").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::outputPackageName)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::outputPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputPackageName").build()}).build();
    private static final SdkField<String> OUTPUT_PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputPackageVersion").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::outputPackageVersion)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::outputPackageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputPackageVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::statusAsString)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::statusMessage)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Map<String, String>> TEMPLATE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TemplateParameters").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::templateParameters)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::templateParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateType").getter(DescribeNodeFromTemplateJobResponse.getter(DescribeNodeFromTemplateJobResponse::templateTypeAsString)).setter(DescribeNodeFromTemplateJobResponse.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD, JOB_ID_FIELD, JOB_TAGS_FIELD, LAST_UPDATED_TIME_FIELD, NODE_DESCRIPTION_FIELD, NODE_NAME_FIELD, OUTPUT_PACKAGE_NAME_FIELD, OUTPUT_PACKAGE_VERSION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TEMPLATE_PARAMETERS_FIELD, TEMPLATE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreatedTime", CREATED_TIME_FIELD);
            this.put("JobId", JOB_ID_FIELD);
            this.put("JobTags", JOB_TAGS_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("NodeDescription", NODE_DESCRIPTION_FIELD);
            this.put("NodeName", NODE_NAME_FIELD);
            this.put("OutputPackageName", OUTPUT_PACKAGE_NAME_FIELD);
            this.put("OutputPackageVersion", OUTPUT_PACKAGE_VERSION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("TemplateParameters", TEMPLATE_PARAMETERS_FIELD);
            this.put("TemplateType", TEMPLATE_TYPE_FIELD);
        }
    });
    private final Instant createdTime;
    private final String jobId;
    private final List<JobResourceTags> jobTags;
    private final Instant lastUpdatedTime;
    private final String nodeDescription;
    private final String nodeName;
    private final String outputPackageName;
    private final String outputPackageVersion;
    private final String status;
    private final String statusMessage;
    private final Map<String, String> templateParameters;
    private final String templateType;

    private DescribeNodeFromTemplateJobResponse(BuilderImpl builder) {
        super(builder);
        this.createdTime = builder.createdTime;
        this.jobId = builder.jobId;
        this.jobTags = builder.jobTags;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.nodeDescription = builder.nodeDescription;
        this.nodeName = builder.nodeName;
        this.outputPackageName = builder.outputPackageName;
        this.outputPackageVersion = builder.outputPackageVersion;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.templateParameters = builder.templateParameters;
        this.templateType = builder.templateType;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final boolean hasJobTags() {
        return this.jobTags != null && !(this.jobTags instanceof SdkAutoConstructList);
    }

    public final List<JobResourceTags> jobTags() {
        return this.jobTags;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String nodeDescription() {
        return this.nodeDescription;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final String outputPackageName() {
        return this.outputPackageName;
    }

    public final String outputPackageVersion() {
        return this.outputPackageVersion;
    }

    public final NodeFromTemplateJobStatus status() {
        return NodeFromTemplateJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final boolean hasTemplateParameters() {
        return this.templateParameters != null && !(this.templateParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> templateParameters() {
        return this.templateParameters;
    }

    public final TemplateType templateType() {
        return TemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTags() ? this.jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputPackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateParameters() ? this.templateParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeFromTemplateJobResponse)) {
            return false;
        }
        DescribeNodeFromTemplateJobResponse other = (DescribeNodeFromTemplateJobResponse)((Object)obj);
        return Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.jobId(), other.jobId()) && this.hasJobTags() == other.hasJobTags() && Objects.equals(this.jobTags(), other.jobTags()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.nodeDescription(), other.nodeDescription()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.outputPackageName(), other.outputPackageName()) && Objects.equals(this.outputPackageVersion(), other.outputPackageVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasTemplateParameters() == other.hasTemplateParameters() && Objects.equals(this.templateParameters(), other.templateParameters()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNodeFromTemplateJobResponse").add("CreatedTime", (Object)this.createdTime()).add("JobId", (Object)this.jobId()).add("JobTags", this.hasJobTags() ? this.jobTags() : null).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("NodeDescription", (Object)this.nodeDescription()).add("NodeName", (Object)this.nodeName()).add("OutputPackageName", (Object)this.outputPackageName()).add("OutputPackageVersion", (Object)this.outputPackageVersion()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("TemplateParameters", (Object)(this.templateParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateType", (Object)this.templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobTags": {
                return Optional.ofNullable(clazz.cast(this.jobTags()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "NodeDescription": {
                return Optional.ofNullable(clazz.cast(this.nodeDescription()));
            }
            case "NodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "OutputPackageName": {
                return Optional.ofNullable(clazz.cast(this.outputPackageName()));
            }
            case "OutputPackageVersion": {
                return Optional.ofNullable(clazz.cast(this.outputPackageVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "TemplateParameters": {
                return Optional.ofNullable(clazz.cast(this.templateParameters()));
            }
            case "TemplateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeFromTemplateJobResponse, T> g) {
        return obj -> g.apply((DescribeNodeFromTemplateJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private Instant createdTime;
        private String jobId;
        private List<JobResourceTags> jobTags = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdatedTime;
        private String nodeDescription;
        private String nodeName;
        private String outputPackageName;
        private String outputPackageVersion;
        private String status;
        private String statusMessage;
        private Map<String, String> templateParameters = DefaultSdkAutoConstructMap.getInstance();
        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeFromTemplateJobResponse model) {
            super(model);
            this.createdTime(model.createdTime);
            this.jobId(model.jobId);
            this.jobTags(model.jobTags);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.nodeDescription(model.nodeDescription);
            this.nodeName(model.nodeName);
            this.outputPackageName(model.outputPackageName);
            this.outputPackageVersion(model.outputPackageVersion);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.templateParameters(model.templateParameters);
            this.templateType(model.templateType);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final List<JobResourceTags.Builder> getJobTags() {
            List<JobResourceTags.Builder> result = JobTagsListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<JobResourceTags.BuilderImpl> jobTags) {
            this.jobTags = JobTagsListCopier.copyFromBuilder(jobTags);
        }

        @Override
        public final Builder jobTags(Collection<JobResourceTags> jobTags) {
            this.jobTags = JobTagsListCopier.copy(jobTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(JobResourceTags ... jobTags) {
            this.jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Consumer<JobResourceTags.Builder> ... jobTags) {
            this.jobTags(Stream.of(jobTags).map(c -> (JobResourceTags)((JobResourceTags.Builder)JobResourceTags.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getNodeDescription() {
            return this.nodeDescription;
        }

        public final void setNodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
        }

        @Override
        public final Builder nodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getOutputPackageName() {
            return this.outputPackageName;
        }

        public final void setOutputPackageName(String outputPackageName) {
            this.outputPackageName = outputPackageName;
        }

        @Override
        public final Builder outputPackageName(String outputPackageName) {
            this.outputPackageName = outputPackageName;
            return this;
        }

        public final String getOutputPackageVersion() {
            return this.outputPackageVersion;
        }

        public final void setOutputPackageVersion(String outputPackageVersion) {
            this.outputPackageVersion = outputPackageVersion;
        }

        @Override
        public final Builder outputPackageVersion(String outputPackageVersion) {
            this.outputPackageVersion = outputPackageVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NodeFromTemplateJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Map<String, String> getTemplateParameters() {
            if (this.templateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.templateParameters;
        }

        public final void setTemplateParameters(Map<String, String> templateParameters) {
            this.templateParameters = TemplateParametersMapCopier.copy(templateParameters);
        }

        @Override
        public final Builder templateParameters(Map<String, String> templateParameters) {
            this.templateParameters = TemplateParametersMapCopier.copy(templateParameters);
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public DescribeNodeFromTemplateJobResponse build() {
            return new DescribeNodeFromTemplateJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNodeFromTemplateJobResponse> {
        public Builder createdTime(Instant var1);

        public Builder jobId(String var1);

        public Builder jobTags(Collection<JobResourceTags> var1);

        public Builder jobTags(JobResourceTags ... var1);

        public Builder jobTags(Consumer<JobResourceTags.Builder> ... var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder nodeDescription(String var1);

        public Builder nodeName(String var1);

        public Builder outputPackageName(String var1);

        public Builder outputPackageVersion(String var1);

        public Builder status(String var1);

        public Builder status(NodeFromTemplateJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder templateParameters(Map<String, String> var1);

        public Builder templateType(String var1);

        public Builder templateType(TemplateType var1);
    }
}

