/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PortType {
    BOOLEAN("BOOLEAN"),
    STRING("STRING"),
    INT32("INT32"),
    FLOAT32("FLOAT32"),
    MEDIA("MEDIA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PortType> VALUE_MAP;
    private final String value;

    private PortType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PortType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PortType> knownValues() {
        EnumSet<PortType> knownValues = EnumSet.allOf(PortType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PortType.class, PortType::toString);
    }
}

