/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeSignalValue {
    PAUSE("PAUSE"),
    RESUME("RESUME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeSignalValue> VALUE_MAP;
    private final String value;

    private NodeSignalValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeSignalValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeSignalValue> knownValues() {
        EnumSet<NodeSignalValue> knownValues = EnumSet.allOf(NodeSignalValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeSignalValue.class, NodeSignalValue::toString);
    }
}

