/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.panorama.DefaultPanoramaBaseClientBuilder;
import software.amazon.awssdk.services.panorama.DefaultPanoramaClient;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.PanoramaClientBuilder;
import software.amazon.awssdk.services.panorama.PanoramaServiceClientConfiguration;
import software.amazon.awssdk.services.panorama.endpoints.PanoramaEndpointProvider;

@SdkInternalApi
final class DefaultPanoramaClientBuilder
extends DefaultPanoramaBaseClientBuilder<PanoramaClientBuilder, PanoramaClient>
implements PanoramaClientBuilder {
    DefaultPanoramaClientBuilder() {
    }

    @Override
    public DefaultPanoramaClientBuilder endpointProvider(PanoramaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PanoramaClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPanoramaClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        PanoramaServiceClientConfiguration serviceClientConfiguration = PanoramaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultPanoramaClient(serviceClientConfiguration, clientConfiguration);
    }
}

