/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceType {
    PANORAMA_APPLIANCE_DEVELOPER_KIT("PANORAMA_APPLIANCE_DEVELOPER_KIT"),
    PANORAMA_APPLIANCE("PANORAMA_APPLIANCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceType> VALUE_MAP;
    private final String value;

    private DeviceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceType> knownValues() {
        EnumSet<DeviceType> knownValues = EnumSet.allOf(DeviceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceType.class, DeviceType::toString);
    }
}

