/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.PackageImportJobStatus;
import software.amazon.awssdk.services.panorama.model.PackageImportJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageImportJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageImportJob> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(PackageImportJob.getter(PackageImportJob::jobId)).setter(PackageImportJob.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(PackageImportJob.getter(PackageImportJob::jobTypeAsString)).setter(PackageImportJob.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PackageImportJob.getter(PackageImportJob::statusAsString)).setter(PackageImportJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(PackageImportJob.getter(PackageImportJob::statusMessage)).setter(PackageImportJob.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(PackageImportJob.getter(PackageImportJob::createdTime)).setter(PackageImportJob.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(PackageImportJob.getter(PackageImportJob::lastUpdatedTime)).setter(PackageImportJob.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_TYPE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String jobType;
    private final String status;
    private final String statusMessage;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;

    private PackageImportJob(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobType = builder.jobType;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final PackageImportJobType jobType() {
        return PackageImportJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final PackageImportJobStatus status() {
        return PackageImportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageImportJob)) {
            return false;
        }
        PackageImportJob other = (PackageImportJob)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"PackageImportJob").add("JobId", (Object)this.jobId()).add("JobType", (Object)this.jobTypeAsString()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageImportJob, T> g) {
        return obj -> g.apply((PackageImportJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobType;
        private String status;
        private String statusMessage;
        private Instant createdTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageImportJob model) {
            this.jobId(model.jobId);
            this.jobType(model.jobType);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        @Transient
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        @Transient
        public final Builder jobType(PackageImportJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(PackageImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public PackageImportJob build() {
            return new PackageImportJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageImportJob> {
        public Builder jobId(String var1);

        public Builder jobType(String var1);

        public Builder jobType(PackageImportJobType var1);

        public Builder status(String var1);

        public Builder status(PackageImportJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

