/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EthernetStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EthernetStatus> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(EthernetStatus.getter(EthernetStatus::ipAddress)).setter(EthernetStatus.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionStatus").getter(EthernetStatus.getter(EthernetStatus::connectionStatusAsString)).setter(EthernetStatus.setter(Builder::connectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final SdkField<String> HW_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HwAddress").getter(EthernetStatus.getter(EthernetStatus::hwAddress)).setter(EthernetStatus.setter(Builder::hwAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HwAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD, CONNECTION_STATUS_FIELD, HW_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipAddress;
    private final String connectionStatus;
    private final String hwAddress;

    private EthernetStatus(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.connectionStatus = builder.connectionStatus;
        this.hwAddress = builder.hwAddress;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final NetworkConnectionStatus connectionStatus() {
        return NetworkConnectionStatus.fromValue(this.connectionStatus);
    }

    public final String connectionStatusAsString() {
        return this.connectionStatus;
    }

    public final String hwAddress() {
        return this.hwAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hwAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EthernetStatus)) {
            return false;
        }
        EthernetStatus other = (EthernetStatus)obj;
        return Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.connectionStatusAsString(), other.connectionStatusAsString()) && Objects.equals(this.hwAddress(), other.hwAddress());
    }

    public final String toString() {
        return ToString.builder((String)"EthernetStatus").add("IpAddress", (Object)this.ipAddress()).add("ConnectionStatus", (Object)this.connectionStatusAsString()).add("HwAddress", (Object)this.hwAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatusAsString()));
            }
            case "HwAddress": {
                return Optional.ofNullable(clazz.cast(this.hwAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EthernetStatus, T> g) {
        return obj -> g.apply((EthernetStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private String connectionStatus;
        private String hwAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(EthernetStatus model) {
            this.ipAddress(model.ipAddress);
            this.connectionStatus(model.connectionStatus);
            this.hwAddress(model.hwAddress);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        @Transient
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getConnectionStatus() {
            return this.connectionStatus;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @Override
        @Transient
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder connectionStatus(NetworkConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final String getHwAddress() {
            return this.hwAddress;
        }

        public final void setHwAddress(String hwAddress) {
            this.hwAddress = hwAddress;
        }

        @Override
        @Transient
        public final Builder hwAddress(String hwAddress) {
            this.hwAddress = hwAddress;
            return this;
        }

        public EthernetStatus build() {
            return new EthernetStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EthernetStatus> {
        public Builder ipAddress(String var1);

        public Builder connectionStatus(String var1);

        public Builder connectionStatus(NetworkConnectionStatus var1);

        public Builder hwAddress(String var1);
    }
}

