/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus;
import software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.services.panorama.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationInstanceResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribeApplicationInstanceResponse> {
    private static final SdkField<String> APPLICATION_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationInstanceId").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::applicationInstanceId)).setter(DescribeApplicationInstanceResponse.setter(Builder::applicationInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceId").build()}).build();
    private static final SdkField<String> APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationInstanceIdToReplace").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::applicationInstanceIdToReplace)).setter(DescribeApplicationInstanceResponse.setter(Builder::applicationInstanceIdToReplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceIdToReplace").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::arn)).setter(DescribeApplicationInstanceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::createdTime)).setter(DescribeApplicationInstanceResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRuntimeContextDevice").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::defaultRuntimeContextDevice)).setter(DescribeApplicationInstanceResponse.setter(Builder::defaultRuntimeContextDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDevice").build()}).build();
    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRuntimeContextDeviceName").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::defaultRuntimeContextDeviceName)).setter(DescribeApplicationInstanceResponse.setter(Builder::defaultRuntimeContextDeviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDeviceName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::description)).setter(DescribeApplicationInstanceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthStatus").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::healthStatusAsString)).setter(DescribeApplicationInstanceResponse.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::lastUpdatedTime)).setter(DescribeApplicationInstanceResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::name)).setter(DescribeApplicationInstanceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RUNTIME_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeRoleArn").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::runtimeRoleArn)).setter(DescribeApplicationInstanceResponse.setter(Builder::runtimeRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeRoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::statusAsString)).setter(DescribeApplicationInstanceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDescription").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::statusDescription)).setter(DescribeApplicationInstanceResponse.setter(Builder::statusDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDescription").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeApplicationInstanceResponse.getter(DescribeApplicationInstanceResponse::tags)).setter(DescribeApplicationInstanceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INSTANCE_ID_FIELD, APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD, ARN_FIELD, CREATED_TIME_FIELD, DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD, DEFAULT_RUNTIME_CONTEXT_DEVICE_NAME_FIELD, DESCRIPTION_FIELD, HEALTH_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, NAME_FIELD, RUNTIME_ROLE_ARN_FIELD, STATUS_FIELD, STATUS_DESCRIPTION_FIELD, TAGS_FIELD));
    private final String applicationInstanceId;
    private final String applicationInstanceIdToReplace;
    private final String arn;
    private final Instant createdTime;
    private final String defaultRuntimeContextDevice;
    private final String defaultRuntimeContextDeviceName;
    private final String description;
    private final String healthStatus;
    private final Instant lastUpdatedTime;
    private final String name;
    private final String runtimeRoleArn;
    private final String status;
    private final String statusDescription;
    private final Map<String, String> tags;

    private DescribeApplicationInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationInstanceId = builder.applicationInstanceId;
        this.applicationInstanceIdToReplace = builder.applicationInstanceIdToReplace;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.defaultRuntimeContextDevice = builder.defaultRuntimeContextDevice;
        this.defaultRuntimeContextDeviceName = builder.defaultRuntimeContextDeviceName;
        this.description = builder.description;
        this.healthStatus = builder.healthStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.runtimeRoleArn = builder.runtimeRoleArn;
        this.status = builder.status;
        this.statusDescription = builder.statusDescription;
        this.tags = builder.tags;
    }

    public final String applicationInstanceId() {
        return this.applicationInstanceId;
    }

    public final String applicationInstanceIdToReplace() {
        return this.applicationInstanceIdToReplace;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String defaultRuntimeContextDevice() {
        return this.defaultRuntimeContextDevice;
    }

    public final String defaultRuntimeContextDeviceName() {
        return this.defaultRuntimeContextDeviceName;
    }

    public final String description() {
        return this.description;
    }

    public final ApplicationInstanceHealthStatus healthStatus() {
        return ApplicationInstanceHealthStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String runtimeRoleArn() {
        return this.runtimeRoleArn;
    }

    public final ApplicationInstanceStatus status() {
        return ApplicationInstanceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusDescription() {
        return this.statusDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationInstanceIdToReplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRuntimeContextDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRuntimeContextDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationInstanceResponse)) {
            return false;
        }
        DescribeApplicationInstanceResponse other = (DescribeApplicationInstanceResponse)((Object)obj);
        return Objects.equals(this.applicationInstanceId(), other.applicationInstanceId()) && Objects.equals(this.applicationInstanceIdToReplace(), other.applicationInstanceIdToReplace()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.defaultRuntimeContextDevice(), other.defaultRuntimeContextDevice()) && Objects.equals(this.defaultRuntimeContextDeviceName(), other.defaultRuntimeContextDeviceName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.runtimeRoleArn(), other.runtimeRoleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDescription(), other.statusDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationInstanceResponse").add("ApplicationInstanceId", (Object)this.applicationInstanceId()).add("ApplicationInstanceIdToReplace", (Object)this.applicationInstanceIdToReplace()).add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("DefaultRuntimeContextDevice", (Object)this.defaultRuntimeContextDevice()).add("DefaultRuntimeContextDeviceName", (Object)this.defaultRuntimeContextDeviceName()).add("Description", (Object)this.description()).add("HealthStatus", (Object)this.healthStatusAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Name", (Object)this.name()).add("RuntimeRoleArn", (Object)this.runtimeRoleArn()).add("Status", (Object)this.statusAsString()).add("StatusDescription", (Object)this.statusDescription()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationInstanceId": {
                return Optional.ofNullable(clazz.cast(this.applicationInstanceId()));
            }
            case "ApplicationInstanceIdToReplace": {
                return Optional.ofNullable(clazz.cast(this.applicationInstanceIdToReplace()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "DefaultRuntimeContextDevice": {
                return Optional.ofNullable(clazz.cast(this.defaultRuntimeContextDevice()));
            }
            case "DefaultRuntimeContextDeviceName": {
                return Optional.ofNullable(clazz.cast(this.defaultRuntimeContextDeviceName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuntimeRoleArn": {
                return Optional.ofNullable(clazz.cast(this.runtimeRoleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDescription": {
                return Optional.ofNullable(clazz.cast(this.statusDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationInstanceResponse, T> g) {
        return obj -> g.apply((DescribeApplicationInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String applicationInstanceId;
        private String applicationInstanceIdToReplace;
        private String arn;
        private Instant createdTime;
        private String defaultRuntimeContextDevice;
        private String defaultRuntimeContextDeviceName;
        private String description;
        private String healthStatus;
        private Instant lastUpdatedTime;
        private String name;
        private String runtimeRoleArn;
        private String status;
        private String statusDescription;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationInstanceResponse model) {
            super(model);
            this.applicationInstanceId(model.applicationInstanceId);
            this.applicationInstanceIdToReplace(model.applicationInstanceIdToReplace);
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.defaultRuntimeContextDevice(model.defaultRuntimeContextDevice);
            this.defaultRuntimeContextDeviceName(model.defaultRuntimeContextDeviceName);
            this.description(model.description);
            this.healthStatus(model.healthStatus);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.name(model.name);
            this.runtimeRoleArn(model.runtimeRoleArn);
            this.status(model.status);
            this.statusDescription(model.statusDescription);
            this.tags(model.tags);
        }

        public final String getApplicationInstanceId() {
            return this.applicationInstanceId;
        }

        public final void setApplicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
        }

        @Override
        public final Builder applicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
            return this;
        }

        public final String getApplicationInstanceIdToReplace() {
            return this.applicationInstanceIdToReplace;
        }

        public final void setApplicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
        }

        @Override
        public final Builder applicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDefaultRuntimeContextDevice() {
            return this.defaultRuntimeContextDevice;
        }

        public final void setDefaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
        }

        @Override
        public final Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
            return this;
        }

        public final String getDefaultRuntimeContextDeviceName() {
            return this.defaultRuntimeContextDeviceName;
        }

        public final void setDefaultRuntimeContextDeviceName(String defaultRuntimeContextDeviceName) {
            this.defaultRuntimeContextDeviceName = defaultRuntimeContextDeviceName;
        }

        @Override
        public final Builder defaultRuntimeContextDeviceName(String defaultRuntimeContextDeviceName) {
            this.defaultRuntimeContextDeviceName = defaultRuntimeContextDeviceName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(ApplicationInstanceHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuntimeRoleArn() {
            return this.runtimeRoleArn;
        }

        public final void setRuntimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
        }

        @Override
        public final Builder runtimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDescription() {
            return this.statusDescription;
        }

        public final void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        @Override
        public final Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeApplicationInstanceResponse build() {
            return new DescribeApplicationInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationInstanceResponse> {
        public Builder applicationInstanceId(String var1);

        public Builder applicationInstanceIdToReplace(String var1);

        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder defaultRuntimeContextDevice(String var1);

        public Builder defaultRuntimeContextDeviceName(String var1);

        public Builder description(String var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(ApplicationInstanceHealthStatus var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder name(String var1);

        public Builder runtimeRoleArn(String var1);

        public Builder status(String var1);

        public Builder status(ApplicationInstanceStatus var1);

        public Builder statusDescription(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

