/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.DeviceStatus;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionDeviceResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, ProvisionDeviceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ProvisionDeviceResponse.getter(ProvisionDeviceResponse::arn)).setter(ProvisionDeviceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<SdkBytes> CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Certificates").getter(ProvisionDeviceResponse.getter(ProvisionDeviceResponse::certificates)).setter(ProvisionDeviceResponse.setter(Builder::certificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(ProvisionDeviceResponse.getter(ProvisionDeviceResponse::deviceId)).setter(ProvisionDeviceResponse.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> IOT_THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IotThingName").getter(ProvisionDeviceResponse.getter(ProvisionDeviceResponse::iotThingName)).setter(ProvisionDeviceResponse.setter(Builder::iotThingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotThingName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProvisionDeviceResponse.getter(ProvisionDeviceResponse::statusAsString)).setter(ProvisionDeviceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CERTIFICATES_FIELD, DEVICE_ID_FIELD, IOT_THING_NAME_FIELD, STATUS_FIELD));
    private final String arn;
    private final SdkBytes certificates;
    private final String deviceId;
    private final String iotThingName;
    private final String status;

    private ProvisionDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.certificates = builder.certificates;
        this.deviceId = builder.deviceId;
        this.iotThingName = builder.iotThingName;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final SdkBytes certificates() {
        return this.certificates;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String iotThingName() {
        return this.iotThingName;
    }

    public final DeviceStatus status() {
        return DeviceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificates());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotThingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionDeviceResponse)) {
            return false;
        }
        ProvisionDeviceResponse other = (ProvisionDeviceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.certificates(), other.certificates()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.iotThingName(), other.iotThingName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionDeviceResponse").add("Arn", (Object)this.arn()).add("Certificates", (Object)this.certificates()).add("DeviceId", (Object)this.deviceId()).add("IotThingName", (Object)this.iotThingName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "IotThingName": {
                return Optional.ofNullable(clazz.cast(this.iotThingName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionDeviceResponse, T> g) {
        return obj -> g.apply((ProvisionDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String arn;
        private SdkBytes certificates;
        private String deviceId;
        private String iotThingName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionDeviceResponse model) {
            super(model);
            this.arn(model.arn);
            this.certificates(model.certificates);
            this.deviceId(model.deviceId);
            this.iotThingName(model.iotThingName);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ByteBuffer getCertificates() {
            return this.certificates == null ? null : this.certificates.asByteBuffer();
        }

        public final void setCertificates(ByteBuffer certificates) {
            this.certificates(certificates == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)certificates));
        }

        @Override
        @Transient
        public final Builder certificates(SdkBytes certificates) {
            this.certificates = certificates;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getIotThingName() {
            return this.iotThingName;
        }

        public final void setIotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
        }

        @Override
        @Transient
        public final Builder iotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ProvisionDeviceResponse build() {
            return new ProvisionDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvisionDeviceResponse> {
        public Builder arn(String var1);

        public Builder certificates(SdkBytes var1);

        public Builder deviceId(String var1);

        public Builder iotThingName(String var1);

        public Builder status(String var1);

        public Builder status(DeviceStatus var1);
    }
}

