/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.PackageListItem;

final class PackageListCopier {
    PackageListCopier() {
    }

    static List<PackageListItem> copy(Collection<? extends PackageListItem> packageListParam) {
        Object list;
        if (packageListParam == null || packageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            packageListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PackageListItem> copyFromBuilder(Collection<? extends PackageListItem.Builder> packageListParam) {
        Object list;
        if (packageListParam == null || packageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            packageListParam.forEach(entry -> {
                PackageListItem member = (PackageListItem)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PackageListItem.Builder> copyToBuilder(Collection<? extends PackageListItem> packageListParam) {
        Object list;
        if (packageListParam == null || packageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            packageListParam.forEach(entry -> {
                PackageListItem.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

