/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkConnectionStatus {
    CONNECTED("CONNECTED"),
    NOT_CONNECTED("NOT_CONNECTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkConnectionStatus> VALUE_MAP;
    private final String value;

    private NetworkConnectionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkConnectionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkConnectionStatus> knownValues() {
        EnumSet<NetworkConnectionStatus> knownValues = EnumSet.allOf(NetworkConnectionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkConnectionStatus.class, NetworkConnectionStatus::toString);
    }
}

