/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.ConflictExceptionErrorArgument;
import software.amazon.awssdk.services.panorama.model.ConflictExceptionErrorArgumentListCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConflictException
extends PanoramaException
implements ToCopyableBuilder<Builder, ConflictException> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ConflictException.getter(ConflictException::resourceId)).setter(ConflictException.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ConflictException.getter(ConflictException::resourceType)).setter(ConflictException.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> ERROR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorId").getter(ConflictException.getter(ConflictException::errorId)).setter(ConflictException.setter(Builder::errorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorId").build()}).build();
    private static final SdkField<List<ConflictExceptionErrorArgument>> ERROR_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorArguments").getter(ConflictException.getter(ConflictException::errorArguments)).setter(ConflictException.setter(Builder::errorArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConflictExceptionErrorArgument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, ERROR_ID_FIELD, ERROR_ARGUMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String resourceType;
    private final String errorId;
    private final List<ConflictExceptionErrorArgument> errorArguments;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.errorId = builder.errorId;
        this.errorArguments = builder.errorArguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String errorId() {
        return this.errorId;
    }

    public boolean hasErrorArguments() {
        return this.errorArguments != null && !(this.errorArguments instanceof SdkAutoConstructList);
    }

    public List<ConflictExceptionErrorArgument> errorArguments() {
        return this.errorArguments;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaException.BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private String errorId;
        private List<ConflictExceptionErrorArgument> errorArguments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.errorId(model.errorId);
            this.errorArguments(model.errorArguments);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getErrorId() {
            return this.errorId;
        }

        public final void setErrorId(String errorId) {
            this.errorId = errorId;
        }

        @Override
        @Transient
        public final Builder errorId(String errorId) {
            this.errorId = errorId;
            return this;
        }

        public final List<ConflictExceptionErrorArgument.Builder> getErrorArguments() {
            List<ConflictExceptionErrorArgument.Builder> result = ConflictExceptionErrorArgumentListCopier.copyToBuilder(this.errorArguments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorArguments(Collection<ConflictExceptionErrorArgument.BuilderImpl> errorArguments) {
            this.errorArguments = ConflictExceptionErrorArgumentListCopier.copyFromBuilder(errorArguments);
        }

        @Override
        @Transient
        public final Builder errorArguments(Collection<ConflictExceptionErrorArgument> errorArguments) {
            this.errorArguments = ConflictExceptionErrorArgumentListCopier.copy(errorArguments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorArguments(ConflictExceptionErrorArgument ... errorArguments) {
            this.errorArguments(Arrays.asList(errorArguments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorArguments(Consumer<ConflictExceptionErrorArgument.Builder> ... errorArguments) {
            this.errorArguments(Stream.of(errorArguments).map(c -> (ConflictExceptionErrorArgument)((ConflictExceptionErrorArgument.Builder)ConflictExceptionErrorArgument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConflictException>,
    PanoramaException.Builder {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder errorId(String var1);

        public Builder errorArguments(Collection<ConflictExceptionErrorArgument> var1);

        public Builder errorArguments(ConflictExceptionErrorArgument ... var1);

        public Builder errorArguments(Consumer<ConflictExceptionErrorArgument.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

