/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.DeviceType;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.services.panorama.model.UpdateProgress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeviceJobResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribeDeviceJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(DescribeDeviceJobResponse.getter(DescribeDeviceJobResponse::jobId)).setter(DescribeDeviceJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(DescribeDeviceJobResponse.getter(DescribeDeviceJobResponse::deviceId)).setter(DescribeDeviceJobResponse.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceArn").getter(DescribeDeviceJobResponse.getter(DescribeDeviceJobResponse::deviceArn)).setter(DescribeDeviceJobResponse.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(DescribeDeviceJobResponse.getter(DescribeDeviceJobResponse::deviceName)).setter(DescribeDeviceJobResponse.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceType").getter(DescribeDeviceJobResponse.getter(DescribeDeviceJobResponse::deviceTypeAsString)).setter(DescribeDeviceJobResponse.setter(Builder::deviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()}).build();
    private static final SdkField<String> IMAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageVersion").getter(DescribeDeviceJobResponse.getter(DescribeDeviceJobResponse::imageVersion)).setter(DescribeDeviceJobResponse.setter(Builder::imageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeDeviceJobResponse.getter(DescribeDeviceJobResponse::statusAsString)).setter(DescribeDeviceJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeDeviceJobResponse.getter(DescribeDeviceJobResponse::createdTime)).setter(DescribeDeviceJobResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, DEVICE_ID_FIELD, DEVICE_ARN_FIELD, DEVICE_NAME_FIELD, DEVICE_TYPE_FIELD, IMAGE_VERSION_FIELD, STATUS_FIELD, CREATED_TIME_FIELD));
    private final String jobId;
    private final String deviceId;
    private final String deviceArn;
    private final String deviceName;
    private final String deviceType;
    private final String imageVersion;
    private final String status;
    private final Instant createdTime;

    private DescribeDeviceJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.deviceId = builder.deviceId;
        this.deviceArn = builder.deviceArn;
        this.deviceName = builder.deviceName;
        this.deviceType = builder.deviceType;
        this.imageVersion = builder.imageVersion;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final DeviceType deviceType() {
        return DeviceType.fromValue(this.deviceType);
    }

    public final String deviceTypeAsString() {
        return this.deviceType;
    }

    public final String imageVersion() {
        return this.imageVersion;
    }

    public final UpdateProgress status() {
        return UpdateProgress.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceJobResponse)) {
            return false;
        }
        DescribeDeviceJobResponse other = (DescribeDeviceJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.deviceTypeAsString(), other.deviceTypeAsString()) && Objects.equals(this.imageVersion(), other.imageVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeviceJobResponse").add("JobId", (Object)this.jobId()).add("DeviceId", (Object)this.deviceId()).add("DeviceArn", (Object)this.deviceArn()).add("DeviceName", (Object)this.deviceName()).add("DeviceType", (Object)this.deviceTypeAsString()).add("ImageVersion", (Object)this.imageVersion()).add("Status", (Object)this.statusAsString()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "DeviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeAsString()));
            }
            case "ImageVersion": {
                return Optional.ofNullable(clazz.cast(this.imageVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceJobResponse, T> g) {
        return obj -> g.apply((DescribeDeviceJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String deviceId;
        private String deviceArn;
        private String deviceName;
        private String deviceType;
        private String imageVersion;
        private String status;
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.deviceId(model.deviceId);
            this.deviceArn(model.deviceArn);
            this.deviceName(model.deviceName);
            this.deviceType(model.deviceType);
            this.imageVersion(model.imageVersion);
            this.status(model.status);
            this.createdTime(model.createdTime);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        @Transient
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        @Transient
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDeviceType() {
            return this.deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        @Transient
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        @Transient
        public final Builder deviceType(DeviceType deviceType) {
            this.deviceType(deviceType == null ? null : deviceType.toString());
            return this;
        }

        public final String getImageVersion() {
            return this.imageVersion;
        }

        public final void setImageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
        }

        @Override
        @Transient
        public final Builder imageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(UpdateProgress status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public DescribeDeviceJobResponse build() {
            return new DescribeDeviceJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeviceJobResponse> {
        public Builder jobId(String var1);

        public Builder deviceId(String var1);

        public Builder deviceArn(String var1);

        public Builder deviceName(String var1);

        public Builder deviceType(String var1);

        public Builder deviceType(DeviceType var1);

        public Builder imageVersion(String var1);

        public Builder status(String var1);

        public Builder status(UpdateProgress var1);

        public Builder createdTime(Instant var1);
    }
}

