/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobStatus;
import software.amazon.awssdk.services.panorama.model.TemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeFromTemplateJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeFromTemplateJob> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(NodeFromTemplateJob.getter(NodeFromTemplateJob::jobId)).setter(NodeFromTemplateJob.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateType").getter(NodeFromTemplateJob.getter(NodeFromTemplateJob::templateTypeAsString)).setter(NodeFromTemplateJob.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NodeFromTemplateJob.getter(NodeFromTemplateJob::statusAsString)).setter(NodeFromTemplateJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(NodeFromTemplateJob.getter(NodeFromTemplateJob::statusMessage)).setter(NodeFromTemplateJob.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(NodeFromTemplateJob.getter(NodeFromTemplateJob::createdTime)).setter(NodeFromTemplateJob.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeName").getter(NodeFromTemplateJob.getter(NodeFromTemplateJob::nodeName)).setter(NodeFromTemplateJob.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, TEMPLATE_TYPE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_TIME_FIELD, NODE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String templateType;
    private final String status;
    private final String statusMessage;
    private final Instant createdTime;
    private final String nodeName;

    private NodeFromTemplateJob(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.templateType = builder.templateType;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdTime = builder.createdTime;
        this.nodeName = builder.nodeName;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final TemplateType templateType() {
        return TemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public final NodeFromTemplateJobStatus status() {
        return NodeFromTemplateJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeFromTemplateJob)) {
            return false;
        }
        NodeFromTemplateJob other = (NodeFromTemplateJob)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.nodeName(), other.nodeName());
    }

    public final String toString() {
        return ToString.builder((String)"NodeFromTemplateJob").add("JobId", (Object)this.jobId()).add("TemplateType", (Object)this.templateTypeAsString()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreatedTime", (Object)this.createdTime()).add("NodeName", (Object)this.nodeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "TemplateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "NodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeFromTemplateJob, T> g) {
        return obj -> g.apply((NodeFromTemplateJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String templateType;
        private String status;
        private String statusMessage;
        private Instant createdTime;
        private String nodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeFromTemplateJob model) {
            this.jobId(model.jobId);
            this.templateType(model.templateType);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.createdTime(model.createdTime);
            this.nodeName(model.nodeName);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        @Transient
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        @Transient
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(NodeFromTemplateJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        @Transient
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public NodeFromTemplateJob build() {
            return new NodeFromTemplateJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeFromTemplateJob> {
        public Builder jobId(String var1);

        public Builder templateType(String var1);

        public Builder templateType(TemplateType var1);

        public Builder status(String var1);

        public Builder status(NodeFromTemplateJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder createdTime(Instant var1);

        public Builder nodeName(String var1);
    }
}

