/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.NodeInstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeInstance> {
    private static final SdkField<String> NODE_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeInstanceId").getter(NodeInstance.getter(NodeInstance::nodeInstanceId)).setter(NodeInstance.setter(Builder::nodeInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeInstanceId").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(NodeInstance.getter(NodeInstance::nodeId)).setter(NodeInstance.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(NodeInstance.getter(NodeInstance::packageName)).setter(NodeInstance.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(NodeInstance.getter(NodeInstance::packageVersion)).setter(NodeInstance.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<String> PACKAGE_PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackagePatchVersion").getter(NodeInstance.getter(NodeInstance::packagePatchVersion)).setter(NodeInstance.setter(Builder::packagePatchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackagePatchVersion").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeName").getter(NodeInstance.getter(NodeInstance::nodeName)).setter(NodeInstance.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeName").build()}).build();
    private static final SdkField<String> CURRENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentStatus").getter(NodeInstance.getter(NodeInstance::currentStatusAsString)).setter(NodeInstance.setter(Builder::currentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_INSTANCE_ID_FIELD, NODE_ID_FIELD, PACKAGE_NAME_FIELD, PACKAGE_VERSION_FIELD, PACKAGE_PATCH_VERSION_FIELD, NODE_NAME_FIELD, CURRENT_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodeInstanceId;
    private final String nodeId;
    private final String packageName;
    private final String packageVersion;
    private final String packagePatchVersion;
    private final String nodeName;
    private final String currentStatus;

    private NodeInstance(BuilderImpl builder) {
        this.nodeInstanceId = builder.nodeInstanceId;
        this.nodeId = builder.nodeId;
        this.packageName = builder.packageName;
        this.packageVersion = builder.packageVersion;
        this.packagePatchVersion = builder.packagePatchVersion;
        this.nodeName = builder.nodeName;
        this.currentStatus = builder.currentStatus;
    }

    public final String nodeInstanceId() {
        return this.nodeInstanceId;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String packagePatchVersion() {
        return this.packagePatchVersion;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final NodeInstanceStatus currentStatus() {
        return NodeInstanceStatus.fromValue(this.currentStatus);
    }

    public final String currentStatusAsString() {
        return this.currentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagePatchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInstance)) {
            return false;
        }
        NodeInstance other = (NodeInstance)obj;
        return Objects.equals(this.nodeInstanceId(), other.nodeInstanceId()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.packagePatchVersion(), other.packagePatchVersion()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.currentStatusAsString(), other.currentStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NodeInstance").add("NodeInstanceId", (Object)this.nodeInstanceId()).add("NodeId", (Object)this.nodeId()).add("PackageName", (Object)this.packageName()).add("PackageVersion", (Object)this.packageVersion()).add("PackagePatchVersion", (Object)this.packagePatchVersion()).add("NodeName", (Object)this.nodeName()).add("CurrentStatus", (Object)this.currentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeInstanceId": {
                return Optional.ofNullable(clazz.cast(this.nodeInstanceId()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "PackagePatchVersion": {
                return Optional.ofNullable(clazz.cast(this.packagePatchVersion()));
            }
            case "NodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "CurrentStatus": {
                return Optional.ofNullable(clazz.cast(this.currentStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeInstance, T> g) {
        return obj -> g.apply((NodeInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeInstanceId;
        private String nodeId;
        private String packageName;
        private String packageVersion;
        private String packagePatchVersion;
        private String nodeName;
        private String currentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInstance model) {
            this.nodeInstanceId(model.nodeInstanceId);
            this.nodeId(model.nodeId);
            this.packageName(model.packageName);
            this.packageVersion(model.packageVersion);
            this.packagePatchVersion(model.packagePatchVersion);
            this.nodeName(model.nodeName);
            this.currentStatus(model.currentStatus);
        }

        public final String getNodeInstanceId() {
            return this.nodeInstanceId;
        }

        public final void setNodeInstanceId(String nodeInstanceId) {
            this.nodeInstanceId = nodeInstanceId;
        }

        @Override
        @Transient
        public final Builder nodeInstanceId(String nodeInstanceId) {
            this.nodeInstanceId = nodeInstanceId;
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        @Transient
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        @Transient
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        @Transient
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPackagePatchVersion() {
            return this.packagePatchVersion;
        }

        public final void setPackagePatchVersion(String packagePatchVersion) {
            this.packagePatchVersion = packagePatchVersion;
        }

        @Override
        @Transient
        public final Builder packagePatchVersion(String packagePatchVersion) {
            this.packagePatchVersion = packagePatchVersion;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        @Transient
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getCurrentStatus() {
            return this.currentStatus;
        }

        public final void setCurrentStatus(String currentStatus) {
            this.currentStatus = currentStatus;
        }

        @Override
        @Transient
        public final Builder currentStatus(String currentStatus) {
            this.currentStatus = currentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder currentStatus(NodeInstanceStatus currentStatus) {
            this.currentStatus(currentStatus == null ? null : currentStatus.toString());
            return this;
        }

        public NodeInstance build() {
            return new NodeInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeInstance> {
        public Builder nodeInstanceId(String var1);

        public Builder nodeId(String var1);

        public Builder packageName(String var1);

        public Builder packageVersion(String var1);

        public Builder packagePatchVersion(String var1);

        public Builder nodeName(String var1);

        public Builder currentStatus(String var1);

        public Builder currentStatus(NodeInstanceStatus var1);
    }
}

