/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.GetOutpostBillingInformationRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostBillingInformationResponse;
import software.amazon.awssdk.services.outposts.model.Subscription;

public class GetOutpostBillingInformationIterable
implements SdkIterable<GetOutpostBillingInformationResponse> {
    private final OutpostsClient client;
    private final GetOutpostBillingInformationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetOutpostBillingInformationIterable(OutpostsClient client, GetOutpostBillingInformationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetOutpostBillingInformationResponseFetcher();
    }

    public Iterator<GetOutpostBillingInformationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Subscription> subscriptions() {
        Function<GetOutpostBillingInformationResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetOutpostBillingInformationResponseFetcher
    implements SyncPageFetcher<GetOutpostBillingInformationResponse> {
        private GetOutpostBillingInformationResponseFetcher() {
        }

        public boolean hasNextPage(GetOutpostBillingInformationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetOutpostBillingInformationResponse nextPage(GetOutpostBillingInformationResponse previousPage) {
            if (previousPage == null) {
                return GetOutpostBillingInformationIterable.this.client.getOutpostBillingInformation(GetOutpostBillingInformationIterable.this.firstRequest);
            }
            return GetOutpostBillingInformationIterable.this.client.getOutpostBillingInformation((GetOutpostBillingInformationRequest)((Object)GetOutpostBillingInformationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

