/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.outposts.model.RackPhysicalProperties;
import software.amazon.awssdk.services.outposts.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Site
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Site> {
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteId").getter(Site.getter(Site::siteId)).setter(Site.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Site.getter(Site::accountId)).setter(Site.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Site.getter(Site::name)).setter(Site.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Site.getter(Site::description)).setter(Site.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Site.getter(Site::tags)).setter(Site.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteArn").getter(Site.getter(Site::siteArn)).setter(Site.setter(Builder::siteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteArn").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(Site.getter(Site::notes)).setter(Site.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<String> OPERATING_ADDRESS_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingAddressCountryCode").getter(Site.getter(Site::operatingAddressCountryCode)).setter(Site.setter(Builder::operatingAddressCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingAddressCountryCode").build()}).build();
    private static final SdkField<String> OPERATING_ADDRESS_STATE_OR_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingAddressStateOrRegion").getter(Site.getter(Site::operatingAddressStateOrRegion)).setter(Site.setter(Builder::operatingAddressStateOrRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingAddressStateOrRegion").build()}).build();
    private static final SdkField<String> OPERATING_ADDRESS_CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingAddressCity").getter(Site.getter(Site::operatingAddressCity)).setter(Site.setter(Builder::operatingAddressCity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingAddressCity").build()}).build();
    private static final SdkField<RackPhysicalProperties> RACK_PHYSICAL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RackPhysicalProperties").getter(Site.getter(Site::rackPhysicalProperties)).setter(Site.setter(Builder::rackPhysicalProperties)).constructor(RackPhysicalProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RackPhysicalProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_ID_FIELD, ACCOUNT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, SITE_ARN_FIELD, NOTES_FIELD, OPERATING_ADDRESS_COUNTRY_CODE_FIELD, OPERATING_ADDRESS_STATE_OR_REGION_FIELD, OPERATING_ADDRESS_CITY_FIELD, RACK_PHYSICAL_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Site.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String siteId;
    private final String accountId;
    private final String name;
    private final String description;
    private final Map<String, String> tags;
    private final String siteArn;
    private final String notes;
    private final String operatingAddressCountryCode;
    private final String operatingAddressStateOrRegion;
    private final String operatingAddressCity;
    private final RackPhysicalProperties rackPhysicalProperties;

    private Site(BuilderImpl builder) {
        this.siteId = builder.siteId;
        this.accountId = builder.accountId;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.siteArn = builder.siteArn;
        this.notes = builder.notes;
        this.operatingAddressCountryCode = builder.operatingAddressCountryCode;
        this.operatingAddressStateOrRegion = builder.operatingAddressStateOrRegion;
        this.operatingAddressCity = builder.operatingAddressCity;
        this.rackPhysicalProperties = builder.rackPhysicalProperties;
    }

    public final String siteId() {
        return this.siteId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String siteArn() {
        return this.siteArn;
    }

    public final String notes() {
        return this.notes;
    }

    public final String operatingAddressCountryCode() {
        return this.operatingAddressCountryCode;
    }

    public final String operatingAddressStateOrRegion() {
        return this.operatingAddressStateOrRegion;
    }

    public final String operatingAddressCity() {
        return this.operatingAddressCity;
    }

    public final RackPhysicalProperties rackPhysicalProperties() {
        return this.rackPhysicalProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.siteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingAddressCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingAddressStateOrRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingAddressCity());
        hashCode = 31 * hashCode + Objects.hashCode(this.rackPhysicalProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Site)) {
            return false;
        }
        Site other = (Site)obj;
        return Objects.equals(this.siteId(), other.siteId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.siteArn(), other.siteArn()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.operatingAddressCountryCode(), other.operatingAddressCountryCode()) && Objects.equals(this.operatingAddressStateOrRegion(), other.operatingAddressStateOrRegion()) && Objects.equals(this.operatingAddressCity(), other.operatingAddressCity()) && Objects.equals(this.rackPhysicalProperties(), other.rackPhysicalProperties());
    }

    public final String toString() {
        return ToString.builder((String)"Site").add("SiteId", (Object)this.siteId()).add("AccountId", (Object)this.accountId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("SiteArn", (Object)this.siteArn()).add("Notes", (Object)this.notes()).add("OperatingAddressCountryCode", (Object)this.operatingAddressCountryCode()).add("OperatingAddressStateOrRegion", (Object)this.operatingAddressStateOrRegion()).add("OperatingAddressCity", (Object)this.operatingAddressCity()).add("RackPhysicalProperties", (Object)this.rackPhysicalProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SiteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SiteArn": {
                return Optional.ofNullable(clazz.cast(this.siteArn()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "OperatingAddressCountryCode": {
                return Optional.ofNullable(clazz.cast(this.operatingAddressCountryCode()));
            }
            case "OperatingAddressStateOrRegion": {
                return Optional.ofNullable(clazz.cast(this.operatingAddressStateOrRegion()));
            }
            case "OperatingAddressCity": {
                return Optional.ofNullable(clazz.cast(this.operatingAddressCity()));
            }
            case "RackPhysicalProperties": {
                return Optional.ofNullable(clazz.cast(this.rackPhysicalProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SiteId", SITE_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SiteArn", SITE_ARN_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("OperatingAddressCountryCode", OPERATING_ADDRESS_COUNTRY_CODE_FIELD);
        map.put("OperatingAddressStateOrRegion", OPERATING_ADDRESS_STATE_OR_REGION_FIELD);
        map.put("OperatingAddressCity", OPERATING_ADDRESS_CITY_FIELD);
        map.put("RackPhysicalProperties", RACK_PHYSICAL_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Site, T> g) {
        return obj -> g.apply((Site)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String siteId;
        private String accountId;
        private String name;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String siteArn;
        private String notes;
        private String operatingAddressCountryCode;
        private String operatingAddressStateOrRegion;
        private String operatingAddressCity;
        private RackPhysicalProperties rackPhysicalProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(Site model) {
            this.siteId(model.siteId);
            this.accountId(model.accountId);
            this.name(model.name);
            this.description(model.description);
            this.tags(model.tags);
            this.siteArn(model.siteArn);
            this.notes(model.notes);
            this.operatingAddressCountryCode(model.operatingAddressCountryCode);
            this.operatingAddressStateOrRegion(model.operatingAddressStateOrRegion);
            this.operatingAddressCity(model.operatingAddressCity);
            this.rackPhysicalProperties(model.rackPhysicalProperties);
        }

        public final String getSiteId() {
            return this.siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getSiteArn() {
            return this.siteArn;
        }

        public final void setSiteArn(String siteArn) {
            this.siteArn = siteArn;
        }

        @Override
        public final Builder siteArn(String siteArn) {
            this.siteArn = siteArn;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getOperatingAddressCountryCode() {
            return this.operatingAddressCountryCode;
        }

        public final void setOperatingAddressCountryCode(String operatingAddressCountryCode) {
            this.operatingAddressCountryCode = operatingAddressCountryCode;
        }

        @Override
        public final Builder operatingAddressCountryCode(String operatingAddressCountryCode) {
            this.operatingAddressCountryCode = operatingAddressCountryCode;
            return this;
        }

        public final String getOperatingAddressStateOrRegion() {
            return this.operatingAddressStateOrRegion;
        }

        public final void setOperatingAddressStateOrRegion(String operatingAddressStateOrRegion) {
            this.operatingAddressStateOrRegion = operatingAddressStateOrRegion;
        }

        @Override
        public final Builder operatingAddressStateOrRegion(String operatingAddressStateOrRegion) {
            this.operatingAddressStateOrRegion = operatingAddressStateOrRegion;
            return this;
        }

        public final String getOperatingAddressCity() {
            return this.operatingAddressCity;
        }

        public final void setOperatingAddressCity(String operatingAddressCity) {
            this.operatingAddressCity = operatingAddressCity;
        }

        @Override
        public final Builder operatingAddressCity(String operatingAddressCity) {
            this.operatingAddressCity = operatingAddressCity;
            return this;
        }

        public final RackPhysicalProperties.Builder getRackPhysicalProperties() {
            return this.rackPhysicalProperties != null ? this.rackPhysicalProperties.toBuilder() : null;
        }

        public final void setRackPhysicalProperties(RackPhysicalProperties.BuilderImpl rackPhysicalProperties) {
            this.rackPhysicalProperties = rackPhysicalProperties != null ? rackPhysicalProperties.build() : null;
        }

        @Override
        public final Builder rackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties) {
            this.rackPhysicalProperties = rackPhysicalProperties;
            return this;
        }

        public Site build() {
            return new Site(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Site> {
        public Builder siteId(String var1);

        public Builder accountId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder siteArn(String var1);

        public Builder notes(String var1);

        public Builder operatingAddressCountryCode(String var1);

        public Builder operatingAddressStateOrRegion(String var1);

        public Builder operatingAddressCity(String var1);

        public Builder rackPhysicalProperties(RackPhysicalProperties var1);

        default public Builder rackPhysicalProperties(Consumer<RackPhysicalProperties.Builder> rackPhysicalProperties) {
            return this.rackPhysicalProperties((RackPhysicalProperties)((RackPhysicalProperties.Builder)RackPhysicalProperties.builder().applyMutation(rackPhysicalProperties)).build());
        }
    }
}

