/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AWSServiceName {
    AWS("AWS"),
    EC2("EC2"),
    ELASTICACHE("ELASTICACHE"),
    ELB("ELB"),
    RDS("RDS"),
    ROUTE53("ROUTE53"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AWSServiceName> VALUE_MAP;
    private final String value;

    private AWSServiceName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AWSServiceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AWSServiceName> knownValues() {
        EnumSet<AWSServiceName> knownValues = EnumSet.allOf(AWSServiceName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AWSServiceName.class, AWSServiceName::toString);
    }
}

