/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.ConnectionDetails;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, GetConnectionResponse> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionId").getter(GetConnectionResponse.getter(GetConnectionResponse::connectionId)).setter(GetConnectionResponse.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").build()}).build();
    private static final SdkField<ConnectionDetails> CONNECTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionDetails").getter(GetConnectionResponse.getter(GetConnectionResponse::connectionDetails)).setter(GetConnectionResponse.setter(Builder::connectionDetails)).constructor(ConnectionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, CONNECTION_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConnectionId", CONNECTION_ID_FIELD);
            this.put("ConnectionDetails", CONNECTION_DETAILS_FIELD);
        }
    });
    private final String connectionId;
    private final ConnectionDetails connectionDetails;

    private GetConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.connectionDetails = builder.connectionDetails;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final ConnectionDetails connectionDetails() {
        return this.connectionDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionResponse)) {
            return false;
        }
        GetConnectionResponse other = (GetConnectionResponse)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.connectionDetails(), other.connectionDetails());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectionResponse").add("ConnectionId", (Object)this.connectionId()).add("ConnectionDetails", (Object)this.connectionDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ConnectionDetails": {
                return Optional.ofNullable(clazz.cast(this.connectionDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionResponse, T> g) {
        return obj -> g.apply((GetConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private String connectionId;
        private ConnectionDetails connectionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionResponse model) {
            super(model);
            this.connectionId(model.connectionId);
            this.connectionDetails(model.connectionDetails);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final ConnectionDetails.Builder getConnectionDetails() {
            return this.connectionDetails != null ? this.connectionDetails.toBuilder() : null;
        }

        public final void setConnectionDetails(ConnectionDetails.BuilderImpl connectionDetails) {
            this.connectionDetails = connectionDetails != null ? connectionDetails.build() : null;
        }

        @Override
        public final Builder connectionDetails(ConnectionDetails connectionDetails) {
            this.connectionDetails = connectionDetails;
            return this;
        }

        @Override
        public GetConnectionResponse build() {
            return new GetConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionResponse> {
        public Builder connectionId(String var1);

        public Builder connectionDetails(ConnectionDetails var1);

        default public Builder connectionDetails(Consumer<ConnectionDetails.Builder> connectionDetails) {
            return this.connectionDetails((ConnectionDetails)((ConnectionDetails.Builder)ConnectionDetails.builder().applyMutation(connectionDetails)).build());
        }
    }
}

