/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSitesResponse extends OutpostsResponse implements
        ToCopyableBuilder<ListSitesResponse.Builder, ListSitesResponse> {
    private static final SdkField<List<Site>> SITES_FIELD = SdkField
            .<List<Site>> builder(MarshallingType.LIST)
            .memberName("Sites")
            .getter(getter(ListSitesResponse::sites))
            .setter(setter(Builder::sites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sites").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Site> builder(MarshallingType.SDK_POJO)
                                            .constructor(Site::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSitesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SITES_FIELD, NEXT_TOKEN_FIELD));

    private final List<Site> sites;

    private final String nextToken;

    private ListSitesResponse(BuilderImpl builder) {
        super(builder);
        this.sites = builder.sites;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sites property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSites() {
        return sites != null && !(sites instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Sites property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSites} method.
     * </p>
     * 
     * @return The value of the Sites property for this object.
     */
    public final List<Site> sites() {
        return sites;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSites() ? sites() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSitesResponse)) {
            return false;
        }
        ListSitesResponse other = (ListSitesResponse) obj;
        return hasSites() == other.hasSites() && Objects.equals(sites(), other.sites())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSitesResponse").add("Sites", hasSites() ? sites() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sites":
            return Optional.ofNullable(clazz.cast(sites()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSitesResponse, T> g) {
        return obj -> g.apply((ListSitesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSitesResponse> {
        /**
         * Sets the value of the Sites property for this object.
         *
         * @param sites
         *        The new value for the Sites property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sites(Collection<Site> sites);

        /**
         * Sets the value of the Sites property for this object.
         *
         * @param sites
         *        The new value for the Sites property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sites(Site... sites);

        /**
         * Sets the value of the Sites property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.outposts.model.Site.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.outposts.model.Site#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.outposts.model.Site.Builder#build()} is called immediately and its
         * result is passed to {@link #sites(List<Site>)}.
         * 
         * @param sites
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.outposts.model.Site.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sites(java.util.Collection<Site>)
         */
        Builder sites(Consumer<Site.Builder>... sites);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private List<Site> sites = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSitesResponse model) {
            super(model);
            sites(model.sites);
            nextToken(model.nextToken);
        }

        public final List<Site.Builder> getSites() {
            List<Site.Builder> result = _siteListDefinitionCopier.copyToBuilder(this.sites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSites(Collection<Site.BuilderImpl> sites) {
            this.sites = _siteListDefinitionCopier.copyFromBuilder(sites);
        }

        @Override
        public final Builder sites(Collection<Site> sites) {
            this.sites = _siteListDefinitionCopier.copy(sites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sites(Site... sites) {
            sites(Arrays.asList(sites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sites(Consumer<Site.Builder>... sites) {
            sites(Stream.of(sites).map(c -> Site.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSitesResponse build() {
            return new ListSitesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
