/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.outposts.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Site
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Site> {
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteId").getter(Site.getter(Site::siteId)).setter(Site.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Site.getter(Site::accountId)).setter(Site.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Site.getter(Site::name)).setter(Site.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Site.getter(Site::description)).setter(Site.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Site.getter(Site::tags)).setter(Site.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteArn").getter(Site.getter(Site::siteArn)).setter(Site.setter(Builder::siteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_ID_FIELD, ACCOUNT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, SITE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String siteId;
    private final String accountId;
    private final String name;
    private final String description;
    private final Map<String, String> tags;
    private final String siteArn;

    private Site(BuilderImpl builder) {
        this.siteId = builder.siteId;
        this.accountId = builder.accountId;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.siteArn = builder.siteArn;
    }

    public final String siteId() {
        return this.siteId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String siteArn() {
        return this.siteArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.siteArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Site)) {
            return false;
        }
        Site other = (Site)obj;
        return Objects.equals(this.siteId(), other.siteId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.siteArn(), other.siteArn());
    }

    public final String toString() {
        return ToString.builder((String)"Site").add("SiteId", (Object)this.siteId()).add("AccountId", (Object)this.accountId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("SiteArn", (Object)this.siteArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SiteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SiteArn": {
                return Optional.ofNullable(clazz.cast(this.siteArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Site, T> g) {
        return obj -> g.apply((Site)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String siteId;
        private String accountId;
        private String name;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String siteArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Site model) {
            this.siteId(model.siteId);
            this.accountId(model.accountId);
            this.name(model.name);
            this.description(model.description);
            this.tags(model.tags);
            this.siteArn(model.siteArn);
        }

        public final String getSiteId() {
            return this.siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        @Transient
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getSiteArn() {
            return this.siteArn;
        }

        public final void setSiteArn(String siteArn) {
            this.siteArn = siteArn;
        }

        @Override
        @Transient
        public final Builder siteArn(String siteArn) {
            this.siteArn = siteArn;
            return this;
        }

        public Site build() {
            return new Site(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Site> {
        public Builder siteId(String var1);

        public Builder accountId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder siteArn(String var1);
    }
}

