/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOutpostInstanceTypesResponse extends OutpostsResponse implements
        ToCopyableBuilder<GetOutpostInstanceTypesResponse.Builder, GetOutpostInstanceTypesResponse> {
    private static final SdkField<List<InstanceTypeItem>> INSTANCE_TYPES_FIELD = SdkField
            .<List<InstanceTypeItem>> builder(MarshallingType.LIST)
            .getter(getter(GetOutpostInstanceTypesResponse::instanceTypes))
            .setter(setter(Builder::instanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceTypeItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceTypeItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOutpostInstanceTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOutpostInstanceTypesResponse::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOutpostInstanceTypesResponse::outpostArn)).setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPES_FIELD,
            NEXT_TOKEN_FIELD, OUTPOST_ID_FIELD, OUTPOST_ARN_FIELD));

    private final List<InstanceTypeItem> instanceTypes;

    private final String nextToken;

    private final String outpostId;

    private final String outpostArn;

    private GetOutpostInstanceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceTypes = builder.instanceTypes;
        this.nextToken = builder.nextToken;
        this.outpostId = builder.outpostId;
        this.outpostArn = builder.outpostArn;
    }

    /**
     * Returns true if the InstanceTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceTypes() {
        return instanceTypes != null && !(instanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the InstanceTypes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the InstanceTypes property for this object.
     */
    public List<InstanceTypeItem> instanceTypes() {
        return instanceTypes;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the OutpostId property for this object.
     * 
     * @return The value of the OutpostId property for this object.
     */
    public String outpostId() {
        return outpostId;
    }

    /**
     * Returns the value of the OutpostArn property for this object.
     * 
     * @return The value of the OutpostArn property for this object.
     */
    public String outpostArn() {
        return outpostArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutpostInstanceTypesResponse)) {
            return false;
        }
        GetOutpostInstanceTypesResponse other = (GetOutpostInstanceTypesResponse) obj;
        return Objects.equals(instanceTypes(), other.instanceTypes()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(outpostId(), other.outpostId()) && Objects.equals(outpostArn(), other.outpostArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetOutpostInstanceTypesResponse").add("InstanceTypes", instanceTypes())
                .add("NextToken", nextToken()).add("OutpostId", outpostId()).add("OutpostArn", outpostArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOutpostInstanceTypesResponse, T> g) {
        return obj -> g.apply((GetOutpostInstanceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOutpostInstanceTypesResponse> {
        /**
         * Sets the value of the InstanceTypes property for this object.
         *
         * @param instanceTypes
         *        The new value for the InstanceTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<InstanceTypeItem> instanceTypes);

        /**
         * Sets the value of the InstanceTypes property for this object.
         *
         * @param instanceTypes
         *        The new value for the InstanceTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(InstanceTypeItem... instanceTypes);

        /**
         * Sets the value of the InstanceTypes property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<InstanceTypeItem>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceTypeItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceTypeItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceTypes(List<InstanceTypeItem>)}.
         * 
         * @param instanceTypes
         *        a consumer that will call methods on {@link List<InstanceTypeItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceTypes(List<InstanceTypeItem>)
         */
        Builder instanceTypes(Consumer<InstanceTypeItem.Builder>... instanceTypes);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the OutpostId property for this object.
         *
         * @param outpostId
         *        The new value for the OutpostId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * Sets the value of the OutpostArn property for this object.
         *
         * @param outpostArn
         *        The new value for the OutpostArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private List<InstanceTypeItem> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String outpostId;

        private String outpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutpostInstanceTypesResponse model) {
            super(model);
            instanceTypes(model.instanceTypes);
            nextToken(model.nextToken);
            outpostId(model.outpostId);
            outpostArn(model.outpostArn);
        }

        public final Collection<InstanceTypeItem.Builder> getInstanceTypes() {
            return instanceTypes != null ? instanceTypes.stream().map(InstanceTypeItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder instanceTypes(Collection<InstanceTypeItem> instanceTypes) {
            this.instanceTypes = InstanceTypeListDefinitionCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(InstanceTypeItem... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(Consumer<InstanceTypeItem.Builder>... instanceTypes) {
            instanceTypes(Stream.of(instanceTypes).map(c -> InstanceTypeItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceTypes(Collection<InstanceTypeItem.BuilderImpl> instanceTypes) {
            this.instanceTypes = InstanceTypeListDefinitionCopier.copyFromBuilder(instanceTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOutpostId() {
            return outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public GetOutpostInstanceTypesResponse build() {
            return new GetOutpostInstanceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
