/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a connection to a pipeline endpoint, containing details about the endpoint association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineEndpointConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineEndpointConnection.Builder, PipelineEndpointConnection> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(PipelineEndpointConnection::pipelineArn))
            .setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(PipelineEndpointConnection::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PipelineEndpointConnection::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointOwner").getter(getter(PipelineEndpointConnection::vpcEndpointOwner))
            .setter(setter(Builder::vpcEndpointOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            ENDPOINT_ID_FIELD, STATUS_FIELD, VPC_ENDPOINT_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pipelineArn;

    private final String endpointId;

    private final String status;

    private final String vpcEndpointOwner;

    private PipelineEndpointConnection(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.endpointId = builder.endpointId;
        this.status = builder.status;
        this.vpcEndpointOwner = builder.vpcEndpointOwner;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline in the endpoint connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline in the endpoint connection.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The unique identifier of the endpoint in the connection.
     * </p>
     * 
     * @return The unique identifier of the endpoint in the connection.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The current status of the pipeline endpoint connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pipeline endpoint connection.
     * @see PipelineEndpointStatus
     */
    public final PipelineEndpointStatus status() {
        return PipelineEndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the pipeline endpoint connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pipeline endpoint connection.
     * @see PipelineEndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the VPC endpoint used in this connection.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the VPC endpoint used in this connection.
     */
    public final String vpcEndpointOwner() {
        return vpcEndpointOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineEndpointConnection)) {
            return false;
        }
        PipelineEndpointConnection other = (PipelineEndpointConnection) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn()) && Objects.equals(endpointId(), other.endpointId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(vpcEndpointOwner(), other.vpcEndpointOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineEndpointConnection").add("PipelineArn", pipelineArn()).add("EndpointId", endpointId())
                .add("Status", statusAsString()).add("VpcEndpointOwner", vpcEndpointOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "VpcEndpointOwner":
            return Optional.ofNullable(clazz.cast(vpcEndpointOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("VpcEndpointOwner", VPC_ENDPOINT_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineEndpointConnection, T> g) {
        return obj -> g.apply((PipelineEndpointConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineEndpointConnection> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline in the endpoint connection.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline in the endpoint connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The unique identifier of the endpoint in the connection.
         * </p>
         * 
         * @param endpointId
         *        The unique identifier of the endpoint in the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The current status of the pipeline endpoint connection.
         * </p>
         * 
         * @param status
         *        The current status of the pipeline endpoint connection.
         * @see PipelineEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineEndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the pipeline endpoint connection.
         * </p>
         * 
         * @param status
         *        The current status of the pipeline endpoint connection.
         * @see PipelineEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineEndpointStatus
         */
        Builder status(PipelineEndpointStatus status);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the VPC endpoint used in this connection.
         * </p>
         * 
         * @param vpcEndpointOwner
         *        The Amazon Web Services account ID that owns the VPC endpoint used in this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointOwner(String vpcEndpointOwner);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineArn;

        private String endpointId;

        private String status;

        private String vpcEndpointOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineEndpointConnection model) {
            pipelineArn(model.pipelineArn);
            endpointId(model.endpointId);
            status(model.status);
            vpcEndpointOwner(model.vpcEndpointOwner);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVpcEndpointOwner() {
            return vpcEndpointOwner;
        }

        public final void setVpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
        }

        @Override
        public final Builder vpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
            return this;
        }

        @Override
        public PipelineEndpointConnection build() {
            return new PipelineEndpointConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
