/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a VPC endpoint for an OpenSearch Ingestion pipeline, enabling private connectivity between your VPC and
 * the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineEndpoint.Builder, PipelineEndpoint> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(PipelineEndpoint::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(PipelineEndpoint::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PipelineEndpoint::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(PipelineEndpoint::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<PipelineEndpointVpcOptions> VPC_OPTIONS_FIELD = SdkField
            .<PipelineEndpointVpcOptions> builder(MarshallingType.SDK_POJO).memberName("VpcOptions")
            .getter(getter(PipelineEndpoint::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(PipelineEndpointVpcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()).build();

    private static final SdkField<String> INGEST_ENDPOINT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngestEndpointUrl").getter(getter(PipelineEndpoint::ingestEndpointUrl))
            .setter(setter(Builder::ingestEndpointUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestEndpointUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            ENDPOINT_ID_FIELD, STATUS_FIELD, VPC_ID_FIELD, VPC_OPTIONS_FIELD, INGEST_ENDPOINT_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pipelineArn;

    private final String endpointId;

    private final String status;

    private final String vpcId;

    private final PipelineEndpointVpcOptions vpcOptions;

    private final String ingestEndpointUrl;

    private PipelineEndpoint(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.endpointId = builder.endpointId;
        this.status = builder.status;
        this.vpcId = builder.vpcId;
        this.vpcOptions = builder.vpcOptions;
        this.ingestEndpointUrl = builder.ingestEndpointUrl;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline associated with this endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline associated with this endpoint.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The unique identifier for the pipeline endpoint.
     * </p>
     * 
     * @return The unique identifier for the pipeline endpoint.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The current status of the pipeline endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pipeline endpoint.
     * @see PipelineEndpointStatus
     */
    public final PipelineEndpointStatus status() {
        return PipelineEndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the pipeline endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pipeline endpoint.
     * @see PipelineEndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the VPC where the pipeline endpoint is created.
     * </p>
     * 
     * @return The ID of the VPC where the pipeline endpoint is created.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Configuration options for the VPC endpoint, including subnet and security group settings.
     * </p>
     * 
     * @return Configuration options for the VPC endpoint, including subnet and security group settings.
     */
    public final PipelineEndpointVpcOptions vpcOptions() {
        return vpcOptions;
    }

    /**
     * <p>
     * The URL used to ingest data to the pipeline through the VPC endpoint.
     * </p>
     * 
     * @return The URL used to ingest data to the pipeline through the VPC endpoint.
     */
    public final String ingestEndpointUrl() {
        return ingestEndpointUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(ingestEndpointUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineEndpoint)) {
            return false;
        }
        PipelineEndpoint other = (PipelineEndpoint) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn()) && Objects.equals(endpointId(), other.endpointId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(vpcOptions(), other.vpcOptions())
                && Objects.equals(ingestEndpointUrl(), other.ingestEndpointUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineEndpoint").add("PipelineArn", pipelineArn()).add("EndpointId", endpointId())
                .add("Status", statusAsString()).add("VpcId", vpcId()).add("VpcOptions", vpcOptions())
                .add("IngestEndpointUrl", ingestEndpointUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "VpcOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        case "IngestEndpointUrl":
            return Optional.ofNullable(clazz.cast(ingestEndpointUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcOptions", VPC_OPTIONS_FIELD);
        map.put("IngestEndpointUrl", INGEST_ENDPOINT_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineEndpoint, T> g) {
        return obj -> g.apply((PipelineEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineEndpoint> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline associated with this endpoint.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline associated with this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The unique identifier for the pipeline endpoint.
         * </p>
         * 
         * @param endpointId
         *        The unique identifier for the pipeline endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The current status of the pipeline endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the pipeline endpoint.
         * @see PipelineEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineEndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the pipeline endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the pipeline endpoint.
         * @see PipelineEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineEndpointStatus
         */
        Builder status(PipelineEndpointStatus status);

        /**
         * <p>
         * The ID of the VPC where the pipeline endpoint is created.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC where the pipeline endpoint is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Configuration options for the VPC endpoint, including subnet and security group settings.
         * </p>
         * 
         * @param vpcOptions
         *        Configuration options for the VPC endpoint, including subnet and security group settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(PipelineEndpointVpcOptions vpcOptions);

        /**
         * <p>
         * Configuration options for the VPC endpoint, including subnet and security group settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipelineEndpointVpcOptions.Builder}
         * avoiding the need to create one manually via {@link PipelineEndpointVpcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipelineEndpointVpcOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcOptions(PipelineEndpointVpcOptions)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link PipelineEndpointVpcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(PipelineEndpointVpcOptions)
         */
        default Builder vpcOptions(Consumer<PipelineEndpointVpcOptions.Builder> vpcOptions) {
            return vpcOptions(PipelineEndpointVpcOptions.builder().applyMutation(vpcOptions).build());
        }

        /**
         * <p>
         * The URL used to ingest data to the pipeline through the VPC endpoint.
         * </p>
         * 
         * @param ingestEndpointUrl
         *        The URL used to ingest data to the pipeline through the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestEndpointUrl(String ingestEndpointUrl);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineArn;

        private String endpointId;

        private String status;

        private String vpcId;

        private PipelineEndpointVpcOptions vpcOptions;

        private String ingestEndpointUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineEndpoint model) {
            pipelineArn(model.pipelineArn);
            endpointId(model.endpointId);
            status(model.status);
            vpcId(model.vpcId);
            vpcOptions(model.vpcOptions);
            ingestEndpointUrl(model.ingestEndpointUrl);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final PipelineEndpointVpcOptions.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(PipelineEndpointVpcOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(PipelineEndpointVpcOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final String getIngestEndpointUrl() {
            return ingestEndpointUrl;
        }

        public final void setIngestEndpointUrl(String ingestEndpointUrl) {
            this.ingestEndpointUrl = ingestEndpointUrl;
        }

        @Override
        public final Builder ingestEndpointUrl(String ingestEndpointUrl) {
            this.ingestEndpointUrl = ingestEndpointUrl;
            return this;
        }

        @Override
        public PipelineEndpoint build() {
            return new PipelineEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
