/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.osis.model.BufferOptions;
import software.amazon.awssdk.services.osis.model.EncryptionAtRestOptions;
import software.amazon.awssdk.services.osis.model.LogPublishingOptions;
import software.amazon.awssdk.services.osis.model.OsisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipelineRequest
extends OsisRequest
implements ToCopyableBuilder<Builder, UpdatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineName").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineName)).setter(UpdatePipelineRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PipelineName").build()}).build();
    private static final SdkField<Integer> MIN_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinUnits").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::minUnits)).setter(UpdatePipelineRequest.setter(Builder::minUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinUnits").build()}).build();
    private static final SdkField<Integer> MAX_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxUnits").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::maxUnits)).setter(UpdatePipelineRequest.setter(Builder::maxUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUnits").build()}).build();
    private static final SdkField<String> PIPELINE_CONFIGURATION_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineConfigurationBody").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineConfigurationBody)).setter(UpdatePipelineRequest.setter(Builder::pipelineConfigurationBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineConfigurationBody").build()}).build();
    private static final SdkField<LogPublishingOptions> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingOptions").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::logPublishingOptions)).setter(UpdatePipelineRequest.setter(Builder::logPublishingOptions)).constructor(LogPublishingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build()}).build();
    private static final SdkField<BufferOptions> BUFFER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferOptions").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::bufferOptions)).setter(UpdatePipelineRequest.setter(Builder::bufferOptions)).constructor(BufferOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::encryptionAtRestOptions)).setter(UpdatePipelineRequest.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, MIN_UNITS_FIELD, MAX_UNITS_FIELD, PIPELINE_CONFIGURATION_BODY_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, BUFFER_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePipelineRequest.memberNameToFieldInitializer();
    private final String pipelineName;
    private final Integer minUnits;
    private final Integer maxUnits;
    private final String pipelineConfigurationBody;
    private final LogPublishingOptions logPublishingOptions;
    private final BufferOptions bufferOptions;
    private final EncryptionAtRestOptions encryptionAtRestOptions;

    private UpdatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.minUnits = builder.minUnits;
        this.maxUnits = builder.maxUnits;
        this.pipelineConfigurationBody = builder.pipelineConfigurationBody;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.bufferOptions = builder.bufferOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final Integer minUnits() {
        return this.minUnits;
    }

    public final Integer maxUnits() {
        return this.maxUnits;
    }

    public final String pipelineConfigurationBody() {
        return this.pipelineConfigurationBody;
    }

    public final LogPublishingOptions logPublishingOptions() {
        return this.logPublishingOptions;
    }

    public final BufferOptions bufferOptions() {
        return this.bufferOptions;
    }

    public final EncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineConfigurationBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.minUnits(), other.minUnits()) && Objects.equals(this.maxUnits(), other.maxUnits()) && Objects.equals(this.pipelineConfigurationBody(), other.pipelineConfigurationBody()) && Objects.equals(this.logPublishingOptions(), other.logPublishingOptions()) && Objects.equals(this.bufferOptions(), other.bufferOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipelineRequest").add("PipelineName", (Object)this.pipelineName()).add("MinUnits", (Object)this.minUnits()).add("MaxUnits", (Object)this.maxUnits()).add("PipelineConfigurationBody", (Object)this.pipelineConfigurationBody()).add("LogPublishingOptions", (Object)this.logPublishingOptions()).add("BufferOptions", (Object)this.bufferOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "MinUnits": {
                return Optional.ofNullable(clazz.cast(this.minUnits()));
            }
            case "MaxUnits": {
                return Optional.ofNullable(clazz.cast(this.maxUnits()));
            }
            case "PipelineConfigurationBody": {
                return Optional.ofNullable(clazz.cast(this.pipelineConfigurationBody()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptions()));
            }
            case "BufferOptions": {
                return Optional.ofNullable(clazz.cast(this.bufferOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineName", PIPELINE_NAME_FIELD);
        map.put("MinUnits", MIN_UNITS_FIELD);
        map.put("MaxUnits", MAX_UNITS_FIELD);
        map.put("PipelineConfigurationBody", PIPELINE_CONFIGURATION_BODY_FIELD);
        map.put("LogPublishingOptions", LOG_PUBLISHING_OPTIONS_FIELD);
        map.put("BufferOptions", BUFFER_OPTIONS_FIELD);
        map.put("EncryptionAtRestOptions", ENCRYPTION_AT_REST_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineRequest, T> g) {
        return obj -> g.apply((UpdatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private Integer minUnits;
        private Integer maxUnits;
        private String pipelineConfigurationBody;
        private LogPublishingOptions logPublishingOptions;
        private BufferOptions bufferOptions;
        private EncryptionAtRestOptions encryptionAtRestOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.minUnits(model.minUnits);
            this.maxUnits(model.maxUnits);
            this.pipelineConfigurationBody(model.pipelineConfigurationBody);
            this.logPublishingOptions(model.logPublishingOptions);
            this.bufferOptions(model.bufferOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final Integer getMinUnits() {
            return this.minUnits;
        }

        public final void setMinUnits(Integer minUnits) {
            this.minUnits = minUnits;
        }

        @Override
        public final Builder minUnits(Integer minUnits) {
            this.minUnits = minUnits;
            return this;
        }

        public final Integer getMaxUnits() {
            return this.maxUnits;
        }

        public final void setMaxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
        }

        @Override
        public final Builder maxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
            return this;
        }

        public final String getPipelineConfigurationBody() {
            return this.pipelineConfigurationBody;
        }

        public final void setPipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
        }

        @Override
        public final Builder pipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
            return this;
        }

        public final LogPublishingOptions.Builder getLogPublishingOptions() {
            return this.logPublishingOptions != null ? this.logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(LogPublishingOptions.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptions logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final BufferOptions.Builder getBufferOptions() {
            return this.bufferOptions != null ? this.bufferOptions.toBuilder() : null;
        }

        public final void setBufferOptions(BufferOptions.BuilderImpl bufferOptions) {
            this.bufferOptions = bufferOptions != null ? bufferOptions.build() : null;
        }

        @Override
        public final Builder bufferOptions(BufferOptions bufferOptions) {
            this.bufferOptions = bufferOptions;
            return this;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OsisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePipelineRequest> {
        public Builder pipelineName(String var1);

        public Builder minUnits(Integer var1);

        public Builder maxUnits(Integer var1);

        public Builder pipelineConfigurationBody(String var1);

        public Builder logPublishingOptions(LogPublishingOptions var1);

        default public Builder logPublishingOptions(Consumer<LogPublishingOptions.Builder> logPublishingOptions) {
            return this.logPublishingOptions((LogPublishingOptions)((LogPublishingOptions.Builder)LogPublishingOptions.builder().applyMutation(logPublishingOptions)).build());
        }

        public Builder bufferOptions(BufferOptions var1);

        default public Builder bufferOptions(Consumer<BufferOptions.Builder> bufferOptions) {
            return this.bufferOptions((BufferOptions)((BufferOptions.Builder)BufferOptions.builder().applyMutation(bufferOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptions)((EncryptionAtRestOptions.Builder)EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

