/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineBlueprint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineBlueprint> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueprintName").getter(PipelineBlueprint.getter(PipelineBlueprint::blueprintName)).setter(PipelineBlueprint.setter(Builder::blueprintName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintName").build()}).build();
    private static final SdkField<String> PIPELINE_CONFIGURATION_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineConfigurationBody").getter(PipelineBlueprint.getter(PipelineBlueprint::pipelineConfigurationBody)).setter(PipelineBlueprint.setter(Builder::pipelineConfigurationBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineConfigurationBody").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD, PIPELINE_CONFIGURATION_BODY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String blueprintName;
    private final String pipelineConfigurationBody;

    private PipelineBlueprint(BuilderImpl builder) {
        this.blueprintName = builder.blueprintName;
        this.pipelineConfigurationBody = builder.pipelineConfigurationBody;
    }

    public final String blueprintName() {
        return this.blueprintName;
    }

    public final String pipelineConfigurationBody() {
        return this.pipelineConfigurationBody;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineConfigurationBody());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineBlueprint)) {
            return false;
        }
        PipelineBlueprint other = (PipelineBlueprint)obj;
        return Objects.equals(this.blueprintName(), other.blueprintName()) && Objects.equals(this.pipelineConfigurationBody(), other.pipelineConfigurationBody());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineBlueprint").add("BlueprintName", (Object)this.blueprintName()).add("PipelineConfigurationBody", (Object)this.pipelineConfigurationBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlueprintName": {
                return Optional.ofNullable(clazz.cast(this.blueprintName()));
            }
            case "PipelineConfigurationBody": {
                return Optional.ofNullable(clazz.cast(this.pipelineConfigurationBody()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineBlueprint, T> g) {
        return obj -> g.apply((PipelineBlueprint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueprintName;
        private String pipelineConfigurationBody;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineBlueprint model) {
            this.blueprintName(model.blueprintName);
            this.pipelineConfigurationBody(model.pipelineConfigurationBody);
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getPipelineConfigurationBody() {
            return this.pipelineConfigurationBody;
        }

        public final void setPipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
        }

        @Override
        public final Builder pipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
            return this;
        }

        public PipelineBlueprint build() {
            return new PipelineBlueprint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineBlueprint> {
        public Builder blueprintName(String var1);

        public Builder pipelineConfigurationBody(String var1);
    }
}

