/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal;
import software.amazon.awssdk.services.organizations.model.EnabledServicePrincipalsCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAwsServiceAccessForOrganizationResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListAwsServiceAccessForOrganizationResponse> {
    private static final SdkField<List<EnabledServicePrincipal>> ENABLED_SERVICE_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAwsServiceAccessForOrganizationResponse.getter(ListAwsServiceAccessForOrganizationResponse::enabledServicePrincipals)).setter(ListAwsServiceAccessForOrganizationResponse.setter(Builder::enabledServicePrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledServicePrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnabledServicePrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAwsServiceAccessForOrganizationResponse.getter(ListAwsServiceAccessForOrganizationResponse::nextToken)).setter(ListAwsServiceAccessForOrganizationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_SERVICE_PRINCIPALS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EnabledServicePrincipal> enabledServicePrincipals;
    private final String nextToken;

    private ListAwsServiceAccessForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.enabledServicePrincipals = builder.enabledServicePrincipals;
        this.nextToken = builder.nextToken;
    }

    public List<EnabledServicePrincipal> enabledServicePrincipals() {
        return this.enabledServicePrincipals;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledServicePrincipals());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAwsServiceAccessForOrganizationResponse)) {
            return false;
        }
        ListAwsServiceAccessForOrganizationResponse other = (ListAwsServiceAccessForOrganizationResponse)((Object)obj);
        return Objects.equals(this.enabledServicePrincipals(), other.enabledServicePrincipals()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAwsServiceAccessForOrganizationResponse").add("EnabledServicePrincipals", this.enabledServicePrincipals()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnabledServicePrincipals": {
                return Optional.ofNullable(clazz.cast(this.enabledServicePrincipals()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAwsServiceAccessForOrganizationResponse, T> g) {
        return obj -> g.apply((ListAwsServiceAccessForOrganizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<EnabledServicePrincipal> enabledServicePrincipals = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAwsServiceAccessForOrganizationResponse model) {
            super(model);
            this.enabledServicePrincipals(model.enabledServicePrincipals);
            this.nextToken(model.nextToken);
        }

        public final Collection<EnabledServicePrincipal.Builder> getEnabledServicePrincipals() {
            return this.enabledServicePrincipals != null ? (Collection)this.enabledServicePrincipals.stream().map(EnabledServicePrincipal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enabledServicePrincipals(Collection<EnabledServicePrincipal> enabledServicePrincipals) {
            this.enabledServicePrincipals = EnabledServicePrincipalsCopier.copy(enabledServicePrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledServicePrincipals(EnabledServicePrincipal ... enabledServicePrincipals) {
            this.enabledServicePrincipals(Arrays.asList(enabledServicePrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledServicePrincipals(Consumer<EnabledServicePrincipal.Builder> ... enabledServicePrincipals) {
            this.enabledServicePrincipals(Stream.of(enabledServicePrincipals).map(c -> (EnabledServicePrincipal)((EnabledServicePrincipal.Builder)EnabledServicePrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnabledServicePrincipals(Collection<EnabledServicePrincipal.BuilderImpl> enabledServicePrincipals) {
            this.enabledServicePrincipals = EnabledServicePrincipalsCopier.copyFromBuilder(enabledServicePrincipals);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAwsServiceAccessForOrganizationResponse build() {
            return new ListAwsServiceAccessForOrganizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAwsServiceAccessForOrganizationResponse> {
        public Builder enabledServicePrincipals(Collection<EnabledServicePrincipal> var1);

        public Builder enabledServicePrincipals(EnabledServicePrincipal ... var1);

        public Builder enabledServicePrincipals(Consumer<EnabledServicePrincipal.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

