/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.Account;
import software.amazon.awssdk.services.organizations.model.ListAccountsWithInvalidEffectivePolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsWithInvalidEffectivePolicyResponse;

public class ListAccountsWithInvalidEffectivePolicyIterable
implements SdkIterable<ListAccountsWithInvalidEffectivePolicyResponse> {
    private final OrganizationsClient client;
    private final ListAccountsWithInvalidEffectivePolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountsWithInvalidEffectivePolicyIterable(OrganizationsClient client, ListAccountsWithInvalidEffectivePolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountsWithInvalidEffectivePolicyResponseFetcher();
    }

    public Iterator<ListAccountsWithInvalidEffectivePolicyResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Account> accounts() {
        Function<ListAccountsWithInvalidEffectivePolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.accounts() != null) {
                return response.accounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountsWithInvalidEffectivePolicyResponseFetcher
    implements SyncPageFetcher<ListAccountsWithInvalidEffectivePolicyResponse> {
        private ListAccountsWithInvalidEffectivePolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsWithInvalidEffectivePolicyResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountsWithInvalidEffectivePolicyResponse nextPage(ListAccountsWithInvalidEffectivePolicyResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsWithInvalidEffectivePolicyIterable.this.client.listAccountsWithInvalidEffectivePolicy(ListAccountsWithInvalidEffectivePolicyIterable.this.firstRequest);
            }
            return ListAccountsWithInvalidEffectivePolicyIterable.this.client.listAccountsWithInvalidEffectivePolicy((ListAccountsWithInvalidEffectivePolicyRequest)((Object)ListAccountsWithInvalidEffectivePolicyIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

