/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.HandshakeParty;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InviteAccountToOrganizationRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, InviteAccountToOrganizationRequest> {
    private static final SdkField<HandshakeParty> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InviteAccountToOrganizationRequest.getter(InviteAccountToOrganizationRequest::target)).setter(InviteAccountToOrganizationRequest.setter(Builder::target)).constructor(HandshakeParty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InviteAccountToOrganizationRequest.getter(InviteAccountToOrganizationRequest::notes)).setter(InviteAccountToOrganizationRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, NOTES_FIELD));
    private final HandshakeParty target;
    private final String notes;

    private InviteAccountToOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.target = builder.target;
        this.notes = builder.notes;
    }

    public HandshakeParty target() {
        return this.target;
    }

    public String notes() {
        return this.notes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InviteAccountToOrganizationRequest)) {
            return false;
        }
        InviteAccountToOrganizationRequest other = (InviteAccountToOrganizationRequest)((Object)obj);
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.notes(), other.notes());
    }

    public String toString() {
        return ToString.builder((String)"InviteAccountToOrganizationRequest").add("Target", (Object)this.target()).add("Notes", (Object)(this.notes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InviteAccountToOrganizationRequest, T> g) {
        return obj -> g.apply((InviteAccountToOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private HandshakeParty target;
        private String notes;

        private BuilderImpl() {
        }

        private BuilderImpl(InviteAccountToOrganizationRequest model) {
            super(model);
            this.target(model.target);
            this.notes(model.notes);
        }

        public final HandshakeParty.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        @Override
        public final Builder target(HandshakeParty target) {
            this.target = target;
            return this;
        }

        public final void setTarget(HandshakeParty.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final String getNotes() {
            return this.notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InviteAccountToOrganizationRequest build() {
            return new InviteAccountToOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InviteAccountToOrganizationRequest> {
        public Builder target(HandshakeParty var1);

        default public Builder target(Consumer<HandshakeParty.Builder> target) {
            return this.target((HandshakeParty)((HandshakeParty.Builder)HandshakeParty.builder().applyMutation(target)).build());
        }

        public Builder notes(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

