/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.PolicyIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EffectivePolicyValidationError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EffectivePolicyValidationError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(EffectivePolicyValidationError.getter(EffectivePolicyValidationError::errorCode)).setter(EffectivePolicyValidationError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(EffectivePolicyValidationError.getter(EffectivePolicyValidationError::errorMessage)).setter(EffectivePolicyValidationError.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> PATH_TO_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathToError").getter(EffectivePolicyValidationError.getter(EffectivePolicyValidationError::pathToError)).setter(EffectivePolicyValidationError.setter(Builder::pathToError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathToError").build()}).build();
    private static final SdkField<List<String>> CONTRIBUTING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContributingPolicies").getter(EffectivePolicyValidationError.getter(EffectivePolicyValidationError::contributingPolicies)).setter(EffectivePolicyValidationError.setter(Builder::contributingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, PATH_TO_ERROR_FIELD, CONTRIBUTING_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EffectivePolicyValidationError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final String errorMessage;
    private final String pathToError;
    private final List<String> contributingPolicies;

    private EffectivePolicyValidationError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.pathToError = builder.pathToError;
        this.contributingPolicies = builder.contributingPolicies;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String pathToError() {
        return this.pathToError;
    }

    public final boolean hasContributingPolicies() {
        return this.contributingPolicies != null && !(this.contributingPolicies instanceof SdkAutoConstructList);
    }

    public final List<String> contributingPolicies() {
        return this.contributingPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathToError());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributingPolicies() ? this.contributingPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectivePolicyValidationError)) {
            return false;
        }
        EffectivePolicyValidationError other = (EffectivePolicyValidationError)obj;
        return Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.pathToError(), other.pathToError()) && this.hasContributingPolicies() == other.hasContributingPolicies() && Objects.equals(this.contributingPolicies(), other.contributingPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"EffectivePolicyValidationError").add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).add("PathToError", (Object)this.pathToError()).add("ContributingPolicies", this.hasContributingPolicies() ? this.contributingPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "PathToError": {
                return Optional.ofNullable(clazz.cast(this.pathToError()));
            }
            case "ContributingPolicies": {
                return Optional.ofNullable(clazz.cast(this.contributingPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("PathToError", PATH_TO_ERROR_FIELD);
        map.put("ContributingPolicies", CONTRIBUTING_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EffectivePolicyValidationError, T> g) {
        return obj -> g.apply((EffectivePolicyValidationError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String errorMessage;
        private String pathToError;
        private List<String> contributingPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EffectivePolicyValidationError model) {
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.pathToError(model.pathToError);
            this.contributingPolicies(model.contributingPolicies);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getPathToError() {
            return this.pathToError;
        }

        public final void setPathToError(String pathToError) {
            this.pathToError = pathToError;
        }

        @Override
        public final Builder pathToError(String pathToError) {
            this.pathToError = pathToError;
            return this;
        }

        public final Collection<String> getContributingPolicies() {
            if (this.contributingPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contributingPolicies;
        }

        public final void setContributingPolicies(Collection<String> contributingPolicies) {
            this.contributingPolicies = PolicyIdsCopier.copy(contributingPolicies);
        }

        @Override
        public final Builder contributingPolicies(Collection<String> contributingPolicies) {
            this.contributingPolicies = PolicyIdsCopier.copy(contributingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributingPolicies(String ... contributingPolicies) {
            this.contributingPolicies(Arrays.asList(contributingPolicies));
            return this;
        }

        public EffectivePolicyValidationError build() {
            return new EffectivePolicyValidationError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EffectivePolicyValidationError> {
        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);

        public Builder pathToError(String var1);

        public Builder contributingPolicies(Collection<String> var1);

        public Builder contributingPolicies(String ... var1);
    }
}

