/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.ListParentsRequest;
import software.amazon.awssdk.services.organizations.model.ListParentsResponse;

public class ListParentsIterable
implements SdkIterable<ListParentsResponse> {
    private final OrganizationsClient client;
    private final ListParentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListParentsIterable(OrganizationsClient client, ListParentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListParentsResponseFetcher();
    }

    public Iterator<ListParentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListParentsResponseFetcher
    implements SyncPageFetcher<ListParentsResponse> {
        private ListParentsResponseFetcher() {
        }

        public boolean hasNextPage(ListParentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListParentsResponse nextPage(ListParentsResponse previousPage) {
            if (previousPage == null) {
                return ListParentsIterable.this.client.listParents(ListParentsIterable.this.firstRequest);
            }
            return ListParentsIterable.this.client.listParents((ListParentsRequest)((Object)ListParentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

