/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.ListPoliciesRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesResponse;

public class ListPoliciesIterable
implements SdkIterable<ListPoliciesResponse> {
    private final OrganizationsClient client;
    private final ListPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPoliciesIterable(OrganizationsClient client, ListPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPoliciesResponseFetcher();
    }

    public Iterator<ListPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPoliciesResponseFetcher
    implements SyncPageFetcher<ListPoliciesResponse> {
        private ListPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPoliciesResponse nextPage(ListPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesIterable.this.client.listPolicies(ListPoliciesIterable.this.firstRequest);
            }
            return ListPoliciesIterable.this.client.listPolicies((ListPoliciesRequest)((Object)ListPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

