/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;

public class ListChildrenIterable
implements SdkIterable<ListChildrenResponse> {
    private final OrganizationsClient client;
    private final ListChildrenRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChildrenIterable(OrganizationsClient client, ListChildrenRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChildrenResponseFetcher();
    }

    public Iterator<ListChildrenResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChildrenResponseFetcher
    implements SyncPageFetcher<ListChildrenResponse> {
        private ListChildrenResponseFetcher() {
        }

        public boolean hasNextPage(ListChildrenResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChildrenResponse nextPage(ListChildrenResponse previousPage) {
            if (previousPage == null) {
                return ListChildrenIterable.this.client.listChildren(ListChildrenIterable.this.firstRequest);
            }
            return ListChildrenIterable.this.client.listChildren((ListChildrenRequest)((Object)ListChildrenIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

