/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse;

public class ListAccountsForParentIterable
implements SdkIterable<ListAccountsForParentResponse> {
    private final OrganizationsClient client;
    private final ListAccountsForParentRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountsForParentIterable(OrganizationsClient client, ListAccountsForParentRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountsForParentResponseFetcher();
    }

    public Iterator<ListAccountsForParentResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAccountsForParentResponseFetcher
    implements SyncPageFetcher<ListAccountsForParentResponse> {
        private ListAccountsForParentResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsForParentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountsForParentResponse nextPage(ListAccountsForParentResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsForParentIterable.this.client.listAccountsForParent(ListAccountsForParentIterable.this.firstRequest);
            }
            return ListAccountsForParentIterable.this.client.listAccountsForParent((ListAccountsForParentRequest)((Object)ListAccountsForParentIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

