/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeclineHandshakeRequest extends OrganizationsRequest implements
        ToCopyableBuilder<DeclineHandshakeRequest.Builder, DeclineHandshakeRequest> {
    private static final SdkField<String> HANDSHAKE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HandshakeId").getter(getter(DeclineHandshakeRequest::handshakeId)).setter(setter(Builder::handshakeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HandshakeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HANDSHAKE_ID_FIELD));

    private final String handshakeId;

    private DeclineHandshakeRequest(BuilderImpl builder) {
        super(builder);
        this.handshakeId = builder.handshakeId;
    }

    /**
     * <p>
     * The unique identifier (ID) of the handshake that you want to decline. You can get the ID from the
     * <a>ListHandshakesForAccount</a> operation.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by
     * from 8 to 32 lowercase letters or digits.
     * </p>
     * 
     * @return The unique identifier (ID) of the handshake that you want to decline. You can get the ID from the
     *         <a>ListHandshakesForAccount</a> operation.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-"
     *         followed by from 8 to 32 lowercase letters or digits.
     */
    public final String handshakeId() {
        return handshakeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(handshakeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeclineHandshakeRequest)) {
            return false;
        }
        DeclineHandshakeRequest other = (DeclineHandshakeRequest) obj;
        return Objects.equals(handshakeId(), other.handshakeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeclineHandshakeRequest").add("HandshakeId", handshakeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HandshakeId":
            return Optional.ofNullable(clazz.cast(handshakeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeclineHandshakeRequest, T> g) {
        return obj -> g.apply((DeclineHandshakeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeclineHandshakeRequest> {
        /**
         * <p>
         * The unique identifier (ID) of the handshake that you want to decline. You can get the ID from the
         * <a>ListHandshakesForAccount</a> operation.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-"
         * followed by from 8 to 32 lowercase letters or digits.
         * </p>
         * 
         * @param handshakeId
         *        The unique identifier (ID) of the handshake that you want to decline. You can get the ID from the
         *        <a>ListHandshakesForAccount</a> operation.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-"
         *        followed by from 8 to 32 lowercase letters or digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handshakeId(String handshakeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String handshakeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeclineHandshakeRequest model) {
            super(model);
            handshakeId(model.handshakeId);
        }

        public final String getHandshakeId() {
            return handshakeId;
        }

        public final void setHandshakeId(String handshakeId) {
            this.handshakeId = handshakeId;
        }

        @Override
        public final Builder handshakeId(String handshakeId) {
            this.handshakeId = handshakeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeclineHandshakeRequest build() {
            return new DeclineHandshakeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
