/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.organizations.DefaultOrganizationsBaseClientBuilder;
import software.amazon.awssdk.services.organizations.DefaultOrganizationsClient;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.OrganizationsClientBuilder;
import software.amazon.awssdk.services.organizations.OrganizationsServiceClientConfiguration;
import software.amazon.awssdk.services.organizations.endpoints.OrganizationsEndpointProvider;

@SdkInternalApi
final class DefaultOrganizationsClientBuilder
extends DefaultOrganizationsBaseClientBuilder<OrganizationsClientBuilder, OrganizationsClient>
implements OrganizationsClientBuilder {
    DefaultOrganizationsClientBuilder() {
    }

    @Override
    public DefaultOrganizationsClientBuilder endpointProvider(OrganizationsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OrganizationsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOrganizationsClientBuilder.validateClientOptions(clientConfiguration);
        OrganizationsServiceClientConfiguration serviceClientConfiguration = OrganizationsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultOrganizationsClient(serviceClientConfiguration, clientConfiguration);
    }
}

