/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.services.organizations.model.Root;
import software.amazon.awssdk.services.organizations.model.RootsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRootsResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListRootsResponse> {
    private static final SdkField<List<Root>> ROOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Roots").getter(ListRootsResponse.getter(ListRootsResponse::roots)).setter(ListRootsResponse.setter(Builder::roots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Root::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRootsResponse.getter(ListRootsResponse::nextToken)).setter(ListRootsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Root> roots;
    private final String nextToken;

    private ListRootsResponse(BuilderImpl builder) {
        super(builder);
        this.roots = builder.roots;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRoots() {
        return this.roots != null && !(this.roots instanceof SdkAutoConstructList);
    }

    public final List<Root> roots() {
        return this.roots;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoots() ? this.roots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRootsResponse)) {
            return false;
        }
        ListRootsResponse other = (ListRootsResponse)((Object)obj);
        return this.hasRoots() == other.hasRoots() && Objects.equals(this.roots(), other.roots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRootsResponse").add("Roots", this.hasRoots() ? this.roots() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Roots": {
                return Optional.ofNullable(clazz.cast(this.roots()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRootsResponse, T> g) {
        return obj -> g.apply((ListRootsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<Root> roots = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRootsResponse model) {
            super(model);
            this.roots(model.roots);
            this.nextToken(model.nextToken);
        }

        public final List<Root.Builder> getRoots() {
            List<Root.Builder> result = RootsCopier.copyToBuilder(this.roots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoots(Collection<Root.BuilderImpl> roots) {
            this.roots = RootsCopier.copyFromBuilder(roots);
        }

        @Override
        @Transient
        public final Builder roots(Collection<Root> roots) {
            this.roots = RootsCopier.copy(roots);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder roots(Root ... roots) {
            this.roots(Arrays.asList(roots));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder roots(Consumer<Root.Builder> ... roots) {
            this.roots(Stream.of(roots).map(c -> (Root)((Root.Builder)Root.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRootsResponse build() {
            return new ListRootsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRootsResponse> {
        public Builder roots(Collection<Root> var1);

        public Builder roots(Root ... var1);

        public Builder roots(Consumer<Root.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

