/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.AccessDeniedException;
import software.amazon.awssdk.services.organizations.model.AccessDeniedForDependencyException;
import software.amazon.awssdk.services.organizations.model.AccountAlreadyRegisteredException;
import software.amazon.awssdk.services.organizations.model.AccountNotFoundException;
import software.amazon.awssdk.services.organizations.model.AccountNotRegisteredException;
import software.amazon.awssdk.services.organizations.model.AccountOwnerNotVerifiedException;
import software.amazon.awssdk.services.organizations.model.AlreadyInOrganizationException;
import software.amazon.awssdk.services.organizations.model.AttachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.AttachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.AwsOrganizationsNotInUseException;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.ChildNotFoundException;
import software.amazon.awssdk.services.organizations.model.ConcurrentModificationException;
import software.amazon.awssdk.services.organizations.model.ConstraintViolationException;
import software.amazon.awssdk.services.organizations.model.CreateAccountRequest;
import software.amazon.awssdk.services.organizations.model.CreateAccountResponse;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatusNotFoundException;
import software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest;
import software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountResponse;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.CreatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.CreatePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DeletePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DeletePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest;
import software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorResponse;
import software.amazon.awssdk.services.organizations.model.DescribeAccountRequest;
import software.amazon.awssdk.services.organizations.model.DescribeAccountResponse;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DescribePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DescribePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DestinationParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.DetachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.DetachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest;
import software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessResponse;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.DuplicateAccountException;
import software.amazon.awssdk.services.organizations.model.DuplicateHandshakeException;
import software.amazon.awssdk.services.organizations.model.DuplicateOrganizationalUnitException;
import software.amazon.awssdk.services.organizations.model.DuplicatePolicyAttachmentException;
import software.amazon.awssdk.services.organizations.model.DuplicatePolicyException;
import software.amazon.awssdk.services.organizations.model.EffectivePolicyNotFoundException;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesRequest;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesResponse;
import software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest;
import software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessResponse;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.FinalizingOrganizationException;
import software.amazon.awssdk.services.organizations.model.HandshakeAlreadyInStateException;
import software.amazon.awssdk.services.organizations.model.HandshakeConstraintViolationException;
import software.amazon.awssdk.services.organizations.model.HandshakeNotFoundException;
import software.amazon.awssdk.services.organizations.model.InvalidHandshakeTransitionException;
import software.amazon.awssdk.services.organizations.model.InvalidInputException;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsResponse;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest;
import software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse;
import software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListParentsRequest;
import software.amazon.awssdk.services.organizations.model.ListParentsResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesResponse;
import software.amazon.awssdk.services.organizations.model.ListRootsRequest;
import software.amazon.awssdk.services.organizations.model.ListRootsResponse;
import software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.organizations.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.organizations.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.organizations.model.MasterCannotLeaveOrganizationException;
import software.amazon.awssdk.services.organizations.model.MoveAccountRequest;
import software.amazon.awssdk.services.organizations.model.MoveAccountResponse;
import software.amazon.awssdk.services.organizations.model.OrganizationNotEmptyException;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitNotEmptyException;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitNotFoundException;
import software.amazon.awssdk.services.organizations.model.OrganizationsException;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.services.organizations.model.ParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.PolicyChangesInProgressException;
import software.amazon.awssdk.services.organizations.model.PolicyInUseException;
import software.amazon.awssdk.services.organizations.model.PolicyNotAttachedException;
import software.amazon.awssdk.services.organizations.model.PolicyNotFoundException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeAlreadyEnabledException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeNotAvailableForOrganizationException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeNotEnabledException;
import software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorRequest;
import software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorResponse;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.RootNotFoundException;
import software.amazon.awssdk.services.organizations.model.ServiceException;
import software.amazon.awssdk.services.organizations.model.SourceParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.TagResourceRequest;
import software.amazon.awssdk.services.organizations.model.TagResourceResponse;
import software.amazon.awssdk.services.organizations.model.TargetNotFoundException;
import software.amazon.awssdk.services.organizations.model.TooManyRequestsException;
import software.amazon.awssdk.services.organizations.model.UnsupportedApiEndpointException;
import software.amazon.awssdk.services.organizations.model.UntagResourceRequest;
import software.amazon.awssdk.services.organizations.model.UntagResourceResponse;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse;
import software.amazon.awssdk.services.organizations.paginators.ListAWSServiceAccessForOrganizationIterable;
import software.amazon.awssdk.services.organizations.paginators.ListAccountsForParentIterable;
import software.amazon.awssdk.services.organizations.paginators.ListAccountsIterable;
import software.amazon.awssdk.services.organizations.paginators.ListChildrenIterable;
import software.amazon.awssdk.services.organizations.paginators.ListCreateAccountStatusIterable;
import software.amazon.awssdk.services.organizations.paginators.ListDelegatedAdministratorsIterable;
import software.amazon.awssdk.services.organizations.paginators.ListDelegatedServicesForAccountIterable;
import software.amazon.awssdk.services.organizations.paginators.ListHandshakesForAccountIterable;
import software.amazon.awssdk.services.organizations.paginators.ListHandshakesForOrganizationIterable;
import software.amazon.awssdk.services.organizations.paginators.ListOrganizationalUnitsForParentIterable;
import software.amazon.awssdk.services.organizations.paginators.ListParentsIterable;
import software.amazon.awssdk.services.organizations.paginators.ListPoliciesForTargetIterable;
import software.amazon.awssdk.services.organizations.paginators.ListPoliciesIterable;
import software.amazon.awssdk.services.organizations.paginators.ListRootsIterable;
import software.amazon.awssdk.services.organizations.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.organizations.paginators.ListTargetsForPolicyIterable;
import software.amazon.awssdk.services.organizations.transform.AcceptHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CancelHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateGovCloudAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeclineHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeregisterDelegatedAdministratorRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeCreateAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeEffectivePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DisableAwsServiceAccessRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DisablePolicyTypeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnableAllFeaturesRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnableAwsServiceAccessRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnablePolicyTypeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.InviteAccountToOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.LeaveOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsForParentRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAwsServiceAccessForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListChildrenRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListCreateAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListDelegatedAdministratorsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListDelegatedServicesForAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListOrganizationalUnitsForParentRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListParentsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesForTargetRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListRootsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListTargetsForPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.MoveAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.RegisterDelegatedAdministratorRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.RemoveAccountFromOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdateOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdatePolicyRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultOrganizationsClient
implements OrganizationsClient {
    private static final Logger log = Logger.loggerFor(DefaultOrganizationsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOrganizationsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "organizations";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptHandshakeResponse acceptHandshake(AcceptHandshakeRequest acceptHandshakeRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, HandshakeConstraintViolationException, HandshakeNotFoundException, InvalidHandshakeTransitionException, HandshakeAlreadyInStateException, InvalidInputException, ConcurrentModificationException, ServiceException, TooManyRequestsException, AccessDeniedForDependencyException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptHandshakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, acceptHandshakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptHandshake");
            AcceptHandshakeResponse acceptHandshakeResponse = (AcceptHandshakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptHandshake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptHandshakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptHandshakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$acceptHandshake$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachPolicyResponse attachPolicy(AttachPolicyRequest attachPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, DuplicatePolicyAttachmentException, InvalidInputException, PolicyNotFoundException, PolicyTypeNotEnabledException, ServiceException, TargetNotFoundException, TooManyRequestsException, UnsupportedApiEndpointException, PolicyChangesInProgressException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, attachPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachPolicy");
            AttachPolicyResponse attachPolicyResponse = (AttachPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$attachPolicy$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelHandshakeResponse cancelHandshake(CancelHandshakeRequest cancelHandshakeRequest) throws AccessDeniedException, ConcurrentModificationException, HandshakeNotFoundException, InvalidHandshakeTransitionException, HandshakeAlreadyInStateException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelHandshakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, cancelHandshakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelHandshake");
            CancelHandshakeResponse cancelHandshakeResponse = (CancelHandshakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelHandshake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelHandshakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelHandshakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$cancelHandshake$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccountResponse createAccount(CreateAccountRequest createAccountRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, FinalizingOrganizationException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, createAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccount");
            CreateAccountResponse createAccountResponse = (CreateAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$createAccount$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGovCloudAccountResponse createGovCloudAccount(CreateGovCloudAccountRequest createGovCloudAccountRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, FinalizingOrganizationException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGovCloudAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, createGovCloudAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGovCloudAccount");
            CreateGovCloudAccountResponse createGovCloudAccountResponse = (CreateGovCloudAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGovCloudAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGovCloudAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGovCloudAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGovCloudAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$createGovCloudAccount$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOrganizationResponse createOrganization(CreateOrganizationRequest createOrganizationRequest) throws AccessDeniedException, AlreadyInOrganizationException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AccessDeniedForDependencyException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, createOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOrganization");
            CreateOrganizationResponse createOrganizationResponse = (CreateOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$createOrganization$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOrganizationalUnitResponse createOrganizationalUnit(CreateOrganizationalUnitRequest createOrganizationalUnitRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, DuplicateOrganizationalUnitException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOrganizationalUnitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, createOrganizationalUnitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOrganizationalUnit");
            CreateOrganizationalUnitResponse createOrganizationalUnitResponse = (CreateOrganizationalUnitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrganizationalUnit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrganizationalUnitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createOrganizationalUnitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$createOrganizationalUnit$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePolicyResponse createPolicy(CreatePolicyRequest createPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, DuplicatePolicyException, InvalidInputException, MalformedPolicyDocumentException, PolicyTypeNotAvailableForOrganizationException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, createPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePolicy");
            CreatePolicyResponse createPolicyResponse = (CreatePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$createPolicy$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeclineHandshakeResponse declineHandshake(DeclineHandshakeRequest declineHandshakeRequest) throws AccessDeniedException, ConcurrentModificationException, HandshakeNotFoundException, InvalidHandshakeTransitionException, HandshakeAlreadyInStateException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeclineHandshakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, declineHandshakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeclineHandshake");
            DeclineHandshakeResponse declineHandshakeResponse = (DeclineHandshakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeclineHandshake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)declineHandshakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeclineHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return declineHandshakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$declineHandshake$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOrganizationResponse deleteOrganization(DeleteOrganizationRequest deleteOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, OrganizationNotEmptyException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, deleteOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOrganization");
            DeleteOrganizationResponse deleteOrganizationResponse = (DeleteOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$deleteOrganization$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOrganizationalUnitResponse deleteOrganizationalUnit(DeleteOrganizationalUnitRequest deleteOrganizationalUnitRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, OrganizationalUnitNotEmptyException, OrganizationalUnitNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationalUnitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, deleteOrganizationalUnitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOrganizationalUnit");
            DeleteOrganizationalUnitResponse deleteOrganizationalUnitResponse = (DeleteOrganizationalUnitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganizationalUnit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteOrganizationalUnitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteOrganizationalUnitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$deleteOrganizationalUnit$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, PolicyInUseException, PolicyNotFoundException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, deletePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePolicy");
            DeletePolicyResponse deletePolicyResponse = (DeletePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$deletePolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterDelegatedAdministratorResponse deregisterDelegatedAdministrator(DeregisterDelegatedAdministratorRequest deregisterDelegatedAdministratorRequest) throws AccessDeniedException, AccountNotFoundException, AccountNotRegisteredException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, TooManyRequestsException, ServiceException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterDelegatedAdministratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, deregisterDelegatedAdministratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterDelegatedAdministrator");
            DeregisterDelegatedAdministratorResponse deregisterDelegatedAdministratorResponse = (DeregisterDelegatedAdministratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterDelegatedAdministrator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterDelegatedAdministratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterDelegatedAdministratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterDelegatedAdministratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$deregisterDelegatedAdministrator$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountResponse describeAccount(DescribeAccountRequest describeAccountRequest) throws AccessDeniedException, AccountNotFoundException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, describeAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccount");
            DescribeAccountResponse describeAccountResponse = (DescribeAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$describeAccount$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCreateAccountStatusResponse describeCreateAccountStatus(DescribeCreateAccountStatusRequest describeCreateAccountStatusRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, CreateAccountStatusNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCreateAccountStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, describeCreateAccountStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCreateAccountStatus");
            DescribeCreateAccountStatusResponse describeCreateAccountStatusResponse = (DescribeCreateAccountStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCreateAccountStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCreateAccountStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCreateAccountStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCreateAccountStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$describeCreateAccountStatus$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEffectivePolicyResponse describeEffectivePolicy(DescribeEffectivePolicyRequest describeEffectivePolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConstraintViolationException, ServiceException, TooManyRequestsException, TargetNotFoundException, EffectivePolicyNotFoundException, InvalidInputException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEffectivePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, describeEffectivePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEffectivePolicy");
            DescribeEffectivePolicyResponse describeEffectivePolicyResponse = (DescribeEffectivePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEffectivePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEffectivePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEffectivePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEffectivePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$describeEffectivePolicy$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeHandshakeResponse describeHandshake(DescribeHandshakeRequest describeHandshakeRequest) throws AccessDeniedException, ConcurrentModificationException, HandshakeNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHandshakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, describeHandshakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeHandshake");
            DescribeHandshakeResponse describeHandshakeResponse = (DescribeHandshakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHandshake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHandshakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeHandshakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$describeHandshake$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationResponse describeOrganization(DescribeOrganizationRequest describeOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, describeOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganization");
            DescribeOrganizationResponse describeOrganizationResponse = (DescribeOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$describeOrganization$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationalUnitResponse describeOrganizationalUnit(DescribeOrganizationalUnitRequest describeOrganizationalUnitRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, OrganizationalUnitNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationalUnitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, describeOrganizationalUnitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationalUnit");
            DescribeOrganizationalUnitResponse describeOrganizationalUnitResponse = (DescribeOrganizationalUnitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationalUnit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationalUnitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationalUnitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$describeOrganizationalUnit$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePolicyResponse describePolicy(DescribePolicyRequest describePolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, PolicyNotFoundException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, describePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePolicy");
            DescribePolicyResponse describePolicyResponse = (DescribePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$describePolicy$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachPolicyResponse detachPolicy(DetachPolicyRequest detachPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, PolicyNotAttachedException, PolicyNotFoundException, ServiceException, TargetNotFoundException, TooManyRequestsException, UnsupportedApiEndpointException, PolicyChangesInProgressException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, detachPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachPolicy");
            DetachPolicyResponse detachPolicyResponse = (DetachPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$detachPolicy$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableAwsServiceAccessResponse disableAWSServiceAccess(DisableAwsServiceAccessRequest disableAwsServiceAccessRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableAwsServiceAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, disableAwsServiceAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableAWSServiceAccess");
            DisableAwsServiceAccessResponse disableAwsServiceAccessResponse = (DisableAwsServiceAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAWSServiceAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableAwsServiceAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableAwsServiceAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableAwsServiceAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$disableAWSServiceAccess$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisablePolicyTypeResponse disablePolicyType(DisablePolicyTypeRequest disablePolicyTypeRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, PolicyTypeNotEnabledException, RootNotFoundException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, PolicyChangesInProgressException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisablePolicyTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, disablePolicyTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisablePolicyType");
            DisablePolicyTypeResponse disablePolicyTypeResponse = (DisablePolicyTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisablePolicyType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disablePolicyTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisablePolicyTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disablePolicyTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$disablePolicyType$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableAwsServiceAccessResponse enableAWSServiceAccess(EnableAwsServiceAccessRequest enableAwsServiceAccessRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAwsServiceAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, enableAwsServiceAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableAWSServiceAccess");
            EnableAwsServiceAccessResponse enableAwsServiceAccessResponse = (EnableAwsServiceAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAWSServiceAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAwsServiceAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableAwsServiceAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableAwsServiceAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$enableAWSServiceAccess$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableAllFeaturesResponse enableAllFeatures(EnableAllFeaturesRequest enableAllFeaturesRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, HandshakeConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAllFeaturesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, enableAllFeaturesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableAllFeatures");
            EnableAllFeaturesResponse enableAllFeaturesResponse = (EnableAllFeaturesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAllFeatures").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAllFeaturesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableAllFeaturesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableAllFeaturesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$enableAllFeatures$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnablePolicyTypeResponse enablePolicyType(EnablePolicyTypeRequest enablePolicyTypeRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, PolicyTypeAlreadyEnabledException, RootNotFoundException, ServiceException, TooManyRequestsException, PolicyTypeNotAvailableForOrganizationException, UnsupportedApiEndpointException, PolicyChangesInProgressException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnablePolicyTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, enablePolicyTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnablePolicyType");
            EnablePolicyTypeResponse enablePolicyTypeResponse = (EnablePolicyTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnablePolicyType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enablePolicyTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnablePolicyTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enablePolicyTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$enablePolicyType$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InviteAccountToOrganizationResponse inviteAccountToOrganization(InviteAccountToOrganizationRequest inviteAccountToOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, AccountOwnerNotVerifiedException, ConcurrentModificationException, HandshakeConstraintViolationException, DuplicateHandshakeException, ConstraintViolationException, InvalidInputException, FinalizingOrganizationException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InviteAccountToOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, inviteAccountToOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InviteAccountToOrganization");
            InviteAccountToOrganizationResponse inviteAccountToOrganizationResponse = (InviteAccountToOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InviteAccountToOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)inviteAccountToOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InviteAccountToOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return inviteAccountToOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$inviteAccountToOrganization$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaveOrganizationResponse leaveOrganization(LeaveOrganizationRequest leaveOrganizationRequest) throws AccessDeniedException, AccountNotFoundException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, MasterCannotLeaveOrganizationException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LeaveOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, leaveOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LeaveOrganization");
            LeaveOrganizationResponse leaveOrganizationResponse = (LeaveOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LeaveOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)leaveOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new LeaveOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return leaveOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$leaveOrganization$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAwsServiceAccessForOrganizationResponse listAWSServiceAccessForOrganization(ListAwsServiceAccessForOrganizationRequest listAwsServiceAccessForOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAwsServiceAccessForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listAwsServiceAccessForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAWSServiceAccessForOrganization");
            ListAwsServiceAccessForOrganizationResponse listAwsServiceAccessForOrganizationResponse = (ListAwsServiceAccessForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAWSServiceAccessForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAwsServiceAccessForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAwsServiceAccessForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAwsServiceAccessForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listAWSServiceAccessForOrganization$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAWSServiceAccessForOrganizationIterable listAWSServiceAccessForOrganizationPaginator(ListAwsServiceAccessForOrganizationRequest listAwsServiceAccessForOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListAWSServiceAccessForOrganizationIterable(this, this.applyPaginatorUserAgent(listAwsServiceAccessForOrganizationRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountsResponse listAccounts(ListAccountsRequest listAccountsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccounts");
            ListAccountsResponse listAccountsResponse = (ListAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccounts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listAccounts$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAccountsIterable listAccountsPaginator(ListAccountsRequest listAccountsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListAccountsIterable(this, this.applyPaginatorUserAgent(listAccountsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountsForParentResponse listAccountsForParent(ListAccountsForParentRequest listAccountsForParentRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountsForParentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listAccountsForParentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccountsForParent");
            ListAccountsForParentResponse listAccountsForParentResponse = (ListAccountsForParentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountsForParent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountsForParentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAccountsForParentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAccountsForParentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listAccountsForParent$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAccountsForParentIterable listAccountsForParentPaginator(ListAccountsForParentRequest listAccountsForParentRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListAccountsForParentIterable(this, this.applyPaginatorUserAgent(listAccountsForParentRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChildrenResponse listChildren(ListChildrenRequest listChildrenRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChildrenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listChildrenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChildren");
            ListChildrenResponse listChildrenResponse = (ListChildrenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChildren").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listChildrenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChildrenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChildrenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listChildren$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListChildrenIterable listChildrenPaginator(ListChildrenRequest listChildrenRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListChildrenIterable(this, this.applyPaginatorUserAgent(listChildrenRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCreateAccountStatusResponse listCreateAccountStatus(ListCreateAccountStatusRequest listCreateAccountStatusRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCreateAccountStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listCreateAccountStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCreateAccountStatus");
            ListCreateAccountStatusResponse listCreateAccountStatusResponse = (ListCreateAccountStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCreateAccountStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCreateAccountStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCreateAccountStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCreateAccountStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listCreateAccountStatus$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCreateAccountStatusIterable listCreateAccountStatusPaginator(ListCreateAccountStatusRequest listCreateAccountStatusRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListCreateAccountStatusIterable(this, this.applyPaginatorUserAgent(listCreateAccountStatusRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDelegatedAdministratorsResponse listDelegatedAdministrators(ListDelegatedAdministratorsRequest listDelegatedAdministratorsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConstraintViolationException, InvalidInputException, TooManyRequestsException, ServiceException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDelegatedAdministratorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listDelegatedAdministratorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDelegatedAdministrators");
            ListDelegatedAdministratorsResponse listDelegatedAdministratorsResponse = (ListDelegatedAdministratorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDelegatedAdministrators").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDelegatedAdministratorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDelegatedAdministratorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDelegatedAdministratorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listDelegatedAdministrators$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDelegatedAdministratorsIterable listDelegatedAdministratorsPaginator(ListDelegatedAdministratorsRequest listDelegatedAdministratorsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConstraintViolationException, InvalidInputException, TooManyRequestsException, ServiceException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListDelegatedAdministratorsIterable(this, this.applyPaginatorUserAgent(listDelegatedAdministratorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDelegatedServicesForAccountResponse listDelegatedServicesForAccount(ListDelegatedServicesForAccountRequest listDelegatedServicesForAccountRequest) throws AccessDeniedException, AccountNotFoundException, AccountNotRegisteredException, AwsOrganizationsNotInUseException, ConstraintViolationException, InvalidInputException, TooManyRequestsException, ServiceException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDelegatedServicesForAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listDelegatedServicesForAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDelegatedServicesForAccount");
            ListDelegatedServicesForAccountResponse listDelegatedServicesForAccountResponse = (ListDelegatedServicesForAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDelegatedServicesForAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDelegatedServicesForAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDelegatedServicesForAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDelegatedServicesForAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listDelegatedServicesForAccount$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDelegatedServicesForAccountIterable listDelegatedServicesForAccountPaginator(ListDelegatedServicesForAccountRequest listDelegatedServicesForAccountRequest) throws AccessDeniedException, AccountNotFoundException, AccountNotRegisteredException, AwsOrganizationsNotInUseException, ConstraintViolationException, InvalidInputException, TooManyRequestsException, ServiceException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListDelegatedServicesForAccountIterable(this, this.applyPaginatorUserAgent(listDelegatedServicesForAccountRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHandshakesForAccountResponse listHandshakesForAccount(ListHandshakesForAccountRequest listHandshakesForAccountRequest) throws AccessDeniedException, ConcurrentModificationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHandshakesForAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listHandshakesForAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHandshakesForAccount");
            ListHandshakesForAccountResponse listHandshakesForAccountResponse = (ListHandshakesForAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHandshakesForAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHandshakesForAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListHandshakesForAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listHandshakesForAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listHandshakesForAccount$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListHandshakesForAccountIterable listHandshakesForAccountPaginator(ListHandshakesForAccountRequest listHandshakesForAccountRequest) throws AccessDeniedException, ConcurrentModificationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListHandshakesForAccountIterable(this, this.applyPaginatorUserAgent(listHandshakesForAccountRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHandshakesForOrganizationResponse listHandshakesForOrganization(ListHandshakesForOrganizationRequest listHandshakesForOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHandshakesForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listHandshakesForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHandshakesForOrganization");
            ListHandshakesForOrganizationResponse listHandshakesForOrganizationResponse = (ListHandshakesForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHandshakesForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHandshakesForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListHandshakesForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listHandshakesForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listHandshakesForOrganization$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListHandshakesForOrganizationIterable listHandshakesForOrganizationPaginator(ListHandshakesForOrganizationRequest listHandshakesForOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListHandshakesForOrganizationIterable(this, this.applyPaginatorUserAgent(listHandshakesForOrganizationRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOrganizationalUnitsForParentResponse listOrganizationalUnitsForParent(ListOrganizationalUnitsForParentRequest listOrganizationalUnitsForParentRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationalUnitsForParentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listOrganizationalUnitsForParentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOrganizationalUnitsForParent");
            ListOrganizationalUnitsForParentResponse listOrganizationalUnitsForParentResponse = (ListOrganizationalUnitsForParentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizationalUnitsForParent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOrganizationalUnitsForParentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOrganizationalUnitsForParentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOrganizationalUnitsForParentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listOrganizationalUnitsForParent$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListOrganizationalUnitsForParentIterable listOrganizationalUnitsForParentPaginator(ListOrganizationalUnitsForParentRequest listOrganizationalUnitsForParentRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListOrganizationalUnitsForParentIterable(this, this.applyPaginatorUserAgent(listOrganizationalUnitsForParentRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListParentsResponse listParents(ListParentsRequest listParentsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ChildNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListParentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listParentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListParents");
            ListParentsResponse listParentsResponse = (ListParentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listParentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListParentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listParentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listParents$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListParentsIterable listParentsPaginator(ListParentsRequest listParentsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ChildNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListParentsIterable(this, this.applyPaginatorUserAgent(listParentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest listPoliciesRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPolicies");
            ListPoliciesResponse listPoliciesResponse = (ListPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listPolicies$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPoliciesIterable listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListPoliciesIterable(this, this.applyPaginatorUserAgent(listPoliciesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPoliciesForTargetResponse listPoliciesForTarget(ListPoliciesForTargetRequest listPoliciesForTargetRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TargetNotFoundException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPoliciesForTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listPoliciesForTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPoliciesForTarget");
            ListPoliciesForTargetResponse listPoliciesForTargetResponse = (ListPoliciesForTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPoliciesForTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPoliciesForTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPoliciesForTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPoliciesForTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listPoliciesForTarget$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPoliciesForTargetIterable listPoliciesForTargetPaginator(ListPoliciesForTargetRequest listPoliciesForTargetRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TargetNotFoundException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListPoliciesForTargetIterable(this, this.applyPaginatorUserAgent(listPoliciesForTargetRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRootsResponse listRoots(ListRootsRequest listRootsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRootsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listRootsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRoots");
            ListRootsResponse listRootsResponse = (ListRootsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRoots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRootsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRootsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRootsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listRoots$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRootsIterable listRootsPaginator(ListRootsRequest listRootsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListRootsIterable(this, this.applyPaginatorUserAgent(listRootsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, TargetNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listTagsForResource$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, TargetNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTargetsForPolicyResponse listTargetsForPolicy(ListTargetsForPolicyRequest listTargetsForPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, PolicyNotFoundException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTargetsForPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, listTargetsForPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTargetsForPolicy");
            ListTargetsForPolicyResponse listTargetsForPolicyResponse = (ListTargetsForPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTargetsForPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTargetsForPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTargetsForPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTargetsForPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$listTargetsForPolicy$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTargetsForPolicyIterable listTargetsForPolicyPaginator(ListTargetsForPolicyRequest listTargetsForPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, PolicyNotFoundException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListTargetsForPolicyIterable(this, this.applyPaginatorUserAgent(listTargetsForPolicyRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MoveAccountResponse moveAccount(MoveAccountRequest moveAccountRequest) throws AccessDeniedException, InvalidInputException, SourceParentNotFoundException, DestinationParentNotFoundException, DuplicateAccountException, AccountNotFoundException, TooManyRequestsException, ConcurrentModificationException, AwsOrganizationsNotInUseException, ServiceException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MoveAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, moveAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MoveAccount");
            MoveAccountResponse moveAccountResponse = (MoveAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MoveAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)moveAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new MoveAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return moveAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$moveAccount$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterDelegatedAdministratorResponse registerDelegatedAdministrator(RegisterDelegatedAdministratorRequest registerDelegatedAdministratorRequest) throws AccessDeniedException, AccountAlreadyRegisteredException, AccountNotFoundException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, TooManyRequestsException, ServiceException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterDelegatedAdministratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, registerDelegatedAdministratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterDelegatedAdministrator");
            RegisterDelegatedAdministratorResponse registerDelegatedAdministratorResponse = (RegisterDelegatedAdministratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterDelegatedAdministrator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerDelegatedAdministratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterDelegatedAdministratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerDelegatedAdministratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$registerDelegatedAdministrator$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveAccountFromOrganizationResponse removeAccountFromOrganization(RemoveAccountFromOrganizationRequest removeAccountFromOrganizationRequest) throws AccessDeniedException, AccountNotFoundException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, MasterCannotLeaveOrganizationException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveAccountFromOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, removeAccountFromOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveAccountFromOrganization");
            RemoveAccountFromOrganizationResponse removeAccountFromOrganizationResponse = (RemoveAccountFromOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveAccountFromOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeAccountFromOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveAccountFromOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeAccountFromOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$removeAccountFromOrganization$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, ConcurrentModificationException, AwsOrganizationsNotInUseException, TargetNotFoundException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$tagResource$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, ConcurrentModificationException, AwsOrganizationsNotInUseException, TargetNotFoundException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$untagResource$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOrganizationalUnitResponse updateOrganizationalUnit(UpdateOrganizationalUnitRequest updateOrganizationalUnitRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, DuplicateOrganizationalUnitException, InvalidInputException, OrganizationalUnitNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOrganizationalUnitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, updateOrganizationalUnitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOrganizationalUnit");
            UpdateOrganizationalUnitResponse updateOrganizationalUnitResponse = (UpdateOrganizationalUnitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOrganizationalUnit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateOrganizationalUnitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateOrganizationalUnitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$updateOrganizationalUnit$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePolicyResponse updatePolicy(UpdatePolicyRequest updatePolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, DuplicatePolicyException, InvalidInputException, MalformedPolicyDocumentException, PolicyNotFoundException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, PolicyChangesInProgressException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOrganizationsClient.resolveMetricPublishers(this.clientConfiguration, updatePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Organizations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePolicy");
            UpdatePolicyResponse updatePolicyResponse = (UpdatePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOrganizationsClient.lambda$updatePolicy$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(OrganizationsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotAvailableForOrganizationException").exceptionBuilderSupplier(PolicyTypeNotAvailableForOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandshakeNotFoundException").exceptionBuilderSupplier(HandshakeNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateAccountException").exceptionBuilderSupplier(DuplicateAccountException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateHandshakeException").exceptionBuilderSupplier(DuplicateHandshakeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyException").exceptionBuilderSupplier(DuplicatePolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandshakeAlreadyInStateException").exceptionBuilderSupplier(HandshakeAlreadyInStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChildNotFoundException").exceptionBuilderSupplier(ChildNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountOwnerNotVerifiedException").exceptionBuilderSupplier(AccountOwnerNotVerifiedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceException").exceptionBuilderSupplier(ServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedAPIEndpointException").exceptionBuilderSupplier(UnsupportedApiEndpointException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RootNotFoundException").exceptionBuilderSupplier(RootNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationNotEmptyException").exceptionBuilderSupplier(OrganizationNotEmptyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationalUnitNotFoundException").exceptionBuilderSupplier(OrganizationalUnitNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").exceptionBuilderSupplier(PolicyNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeAlreadyEnabledException").exceptionBuilderSupplier(PolicyTypeAlreadyEnabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedForDependencyException").exceptionBuilderSupplier(AccessDeniedForDependencyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyAttachmentException").exceptionBuilderSupplier(DuplicatePolicyAttachmentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MasterCannotLeaveOrganizationException").exceptionBuilderSupplier(MasterCannotLeaveOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyChangesInProgressException").exceptionBuilderSupplier(PolicyChangesInProgressException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DestinationParentNotFoundException").exceptionBuilderSupplier(DestinationParentNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotEnabledException").exceptionBuilderSupplier(PolicyTypeNotEnabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountAlreadyRegisteredException").exceptionBuilderSupplier(AccountAlreadyRegisteredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConstraintViolationException").exceptionBuilderSupplier(ConstraintViolationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetNotFoundException").exceptionBuilderSupplier(TargetNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWSOrganizationsNotInUseException").exceptionBuilderSupplier(AwsOrganizationsNotInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CreateAccountStatusNotFoundException").exceptionBuilderSupplier(CreateAccountStatusNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EffectivePolicyNotFoundException").exceptionBuilderSupplier(EffectivePolicyNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").exceptionBuilderSupplier(AccountNotRegisteredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotAttachedException").exceptionBuilderSupplier(PolicyNotAttachedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyInOrganizationException").exceptionBuilderSupplier(AlreadyInOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountNotFoundException").exceptionBuilderSupplier(AccountNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceParentNotFoundException").exceptionBuilderSupplier(SourceParentNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParentNotFoundException").exceptionBuilderSupplier(ParentNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateOrganizationalUnitException").exceptionBuilderSupplier(DuplicateOrganizationalUnitException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHandshakeTransitionException").exceptionBuilderSupplier(InvalidHandshakeTransitionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandshakeConstraintViolationException").exceptionBuilderSupplier(HandshakeConstraintViolationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyInUseException").exceptionBuilderSupplier(PolicyInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FinalizingOrganizationException").exceptionBuilderSupplier(FinalizingOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationalUnitNotEmptyException").exceptionBuilderSupplier(OrganizationalUnitNotEmptyException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends OrganizationsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.61").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((OrganizationsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updatePolicy$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateOrganizationalUnit$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeAccountFromOrganization$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerDelegatedAdministrator$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$moveAccount$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTargetsForPolicy$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRoots$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPoliciesForTarget$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPolicies$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listParents$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOrganizationalUnitsForParent$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHandshakesForOrganization$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHandshakesForAccount$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDelegatedServicesForAccount$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDelegatedAdministrators$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCreateAccountStatus$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listChildren$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccountsForParent$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccounts$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAWSServiceAccessForOrganization$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$leaveOrganization$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$inviteAccountToOrganization$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enablePolicyType$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableAllFeatures$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableAWSServiceAccess$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disablePolicyType$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableAWSServiceAccess$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachPolicy$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePolicy$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrganizationalUnit$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrganization$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeHandshake$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEffectivePolicy$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCreateAccountStatus$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccount$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterDelegatedAdministrator$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteOrganizationalUnit$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteOrganization$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$declineHandshake$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPolicy$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOrganizationalUnit$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOrganization$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGovCloudAccount$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccount$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelHandshake$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachPolicy$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptHandshake$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

