/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.DelegatedService;
import software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse;

public class ListDelegatedServicesForAccountPublisher
implements SdkPublisher<ListDelegatedServicesForAccountResponse> {
    private final OrganizationsAsyncClient client;
    private final ListDelegatedServicesForAccountRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDelegatedServicesForAccountPublisher(OrganizationsAsyncClient client, ListDelegatedServicesForAccountRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDelegatedServicesForAccountPublisher(OrganizationsAsyncClient client, ListDelegatedServicesForAccountRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDelegatedServicesForAccountResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDelegatedServicesForAccountResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DelegatedService> delegatedServices() {
        Function<ListDelegatedServicesForAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.delegatedServices() != null) {
                return response.delegatedServices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDelegatedServicesForAccountResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDelegatedServicesForAccountResponseFetcher
    implements AsyncPageFetcher<ListDelegatedServicesForAccountResponse> {
        private ListDelegatedServicesForAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListDelegatedServicesForAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDelegatedServicesForAccountResponse> nextPage(ListDelegatedServicesForAccountResponse previousPage) {
            if (previousPage == null) {
                return ListDelegatedServicesForAccountPublisher.this.client.listDelegatedServicesForAccount(ListDelegatedServicesForAccountPublisher.this.firstRequest);
            }
            return ListDelegatedServicesForAccountPublisher.this.client.listDelegatedServicesForAccount((ListDelegatedServicesForAccountRequest)((Object)ListDelegatedServicesForAccountPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

